/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.GlobalDbConfig;
import com.manatee.lowcodedb.newdb.Session;
import com.manatee.lowcodedb.newdb.SqlConnRunner;
import com.manatee.lowcodedb.newdb.dialect.Dialect;
import com.manatee.lowcodedb.newdb.dialect.DialectFactory;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbUtil.class);

    public static SqlConnRunner newSqlConnRunner(Dialect dialect) {
        return SqlConnRunner.create(dialect);
    }

    public static SqlConnRunner newSqlConnRunner(DataSource ds) {
        return SqlConnRunner.create(ds);
    }

    public static SqlConnRunner newSqlConnRunner(Connection conn) {
        return SqlConnRunner.create(DialectFactory.newDialect(conn));
    }

    public static DbClient use() throws BizException {
        return DbClient.use();
    }

    public static DbClient use(DataSource ds) {
        return DbClient.use(ds);
    }

    public static DbClient use(DataSource ds, Dialect dialect) {
        return DbClient.use(ds, dialect);
    }

    public static Session newSession() throws BizException {
        return Session.create(DbUtil.getDs());
    }

    public static Session newSession(DataSource ds) {
        return Session.create(ds);
    }

    public static void close(Object ... objsToClose) {
        for (Object obj : objsToClose) {
            if (null == obj) continue;
            if (obj instanceof AutoCloseable) {
                IoUtil.close((AutoCloseable)((AutoCloseable)obj));
                continue;
            }
            LOGGER.warn("Object {} not a ResultSet or Statement or PreparedStatement or Connection!", (Object)obj.getClass().getName());
        }
    }

    public static DataSource getDs() throws BizException {
        return DSFactory.get();
    }

    public static DataSource getDs(String group) throws BizException {
        return DSFactory.get(group);
    }

    public static DataSource getJndiDsWithLog(String jndiName) {
        try {
            return DbUtil.getJndiDs(jndiName);
        }
        catch (DbRuntimeException e) {
            LOGGER.error("Find JNDI datasource error!", e.getCause());
            return null;
        }
    }

    public static DataSource getJndiDs(String jndiName) {
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static void setShowSqlGlobal(boolean isShowSql, boolean isFormatSql, boolean isShowParams, int level) {
        GlobalDbConfig.setShowSql(isShowSql, isFormatSql, isShowParams, level);
    }

    public static void setCaseInsensitiveGlobal(boolean caseInsensitive) {
        GlobalDbConfig.setCaseInsensitive(caseInsensitive);
    }

    public static void setReturnGeneratedKeyGlobal(boolean returnGeneratedKey) {
        GlobalDbConfig.setReturnGeneratedKey(returnGeneratedKey);
    }

    public static void setDbSettingPathGlobal(String dbSettingPath) {
        GlobalDbConfig.setDbSettingPath(dbSettingPath);
    }
}

