/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

public class ActiveEntity
extends DbEntity {
    private static final long serialVersionUID = 6112321379601134750L;
    private final DbClient db;

    public static ActiveEntity create() throws BizException {
        return new ActiveEntity();
    }

    public static ActiveEntity create(String tableName) throws BizException {
        return new ActiveEntity(tableName);
    }

    public static <T> ActiveEntity parse(T bean) throws BizException {
        return ActiveEntity.create(null).parseBean((Object)bean);
    }

    public static <T> ActiveEntity parse(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) throws BizException {
        return ActiveEntity.create(null).parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    public static <T> ActiveEntity parseWithUnderlineCase(T bean) throws BizException {
        return ActiveEntity.create(null).parseBean((Object)bean, true, true);
    }

    public ActiveEntity() throws BizException {
        this(DbClient.use(), (String)null);
    }

    public ActiveEntity(String tableName) throws BizException {
        this(DbClient.use(), tableName);
    }

    public ActiveEntity(DbEntity entity) throws BizException {
        this(DbClient.use(), entity);
    }

    public ActiveEntity(DbClient db, String tableName) {
        super(tableName);
        this.db = db;
    }

    public ActiveEntity(DbClient db, DbEntity entity) {
        super(entity.getTableName());
        this.putAll((Map)((Object)entity));
        this.db = db;
    }

    @Override
    public ActiveEntity setTableName(String tableName) {
        return (ActiveEntity)super.setTableName(tableName);
    }

    @Override
    public ActiveEntity setFieldNames(Collection<String> fieldNames) {
        return (ActiveEntity)super.setFieldNames(fieldNames);
    }

    @Override
    public ActiveEntity setFieldNames(String ... fieldNames) {
        return (ActiveEntity)super.setFieldNames(fieldNames);
    }

    @Override
    public ActiveEntity addFieldNames(String ... fieldNames) {
        return (ActiveEntity)super.addFieldNames(fieldNames);
    }

    @Override
    public <T> ActiveEntity parseBean(T bean) {
        return (ActiveEntity)super.parseBean((Object)bean);
    }

    @Override
    public <T> ActiveEntity parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return (ActiveEntity)super.parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    @Override
    public ActiveEntity set(String field, Object value) {
        return (ActiveEntity)super.set(field, value);
    }

    @Override
    public ActiveEntity setIgnoreNull(String field, Object value) {
        return (ActiveEntity)super.setIgnoreNull(field, value);
    }

    @Override
    public ActiveEntity clone() {
        return (ActiveEntity)super.clone();
    }

    public ActiveEntity add() {
        try {
            this.db.insert(this);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity load() {
        try {
            DbEntity result = this.db.get(this);
            if (MapUtil.isNotEmpty((Map)((Object)result))) {
                this.putAll((Map)((Object)result));
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity del() {
        try {
            this.db.del(this);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }

    public ActiveEntity update(String primaryKey) {
        try {
            this.db.update(this, DbEntity.create().set(primaryKey, this.get(primaryKey)));
        }
        catch (BizException | SQLException e) {
            throw new DbRuntimeException(e);
        }
        return this;
    }
}

