/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.connector;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.connector.ManateeConnector;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class DruidDataSourceConnector
extends ManateeConnector {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceConnector.class);

    @Override
    public DataSource createDataSource(DataSourceProperties dataSourceProperties) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(11);
            map.put("driverClassName", dataSourceProperties.getDriverClassName());
            map.put("url", dataSourceProperties.getUrl());
            map.put("username", dataSourceProperties.getUsername());
            map.put("password", dataSourceProperties.getPassword());
            map.put("initialSize", "2");
            map.put("minIdle", "2");
            map.put("maxActive", "10");
            map.put("maxWait", "60000");
            map.put("timeBetweenEvictionRunsMillis", "60000");
            map.put("filters", "wall,stat");
            map.put("name", dataSourceProperties.getName());
            return DruidDataSourceFactory.createDataSource(map);
        }
        catch (Exception e) {
            log.warn("[DruidDataSourceConnector.createDataSource]_fail_\u6570\u636e\u6e90\u521b\u5efa\u5931\u8d25\uff0c" + e.getMessage());
            return null;
        }
    }

    @Override
    public void addDataSource(JSONObject dbJson) {
        String name = dbJson.getString("name");
        assert (StringUtil.isNotBlank((String)name));
        String username = dbJson.getString("username");
        String password = dbJson.getString("password");
        String url = dbJson.getString("url");
        String driverClassName = dbJson.getString("driverClassName");
        if (DruidDataSourceConnector.isDbAlreadyExist(name, username, password, url).booleanValue()) {
            log.info("[ManateeDataSourceManager.addDd]_warn: " + name + " \u6570\u636e\u6e90\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
            return;
        }
        DataSource dataSource = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(11);
            if (StringUtils.isNotBlank((CharSequence)driverClassName)) {
                map.put("driverClassName", driverClassName);
            }
            map.put("url", url);
            map.put("username", username);
            map.put("password", password);
            map.put("initialSize", "2");
            map.put("minIdle", "2");
            Integer maximumPoolSize = dbJson.getInteger("maximumPoolSize");
            if (maximumPoolSize != null) {
                map.put("maxActive", maximumPoolSize);
            } else {
                map.put("maxActive", "10");
            }
            map.put("maxWait", "60000");
            map.put("timeBetweenEvictionRunsMillis", "60000");
            map.put("filters", "wall,stat");
            dataSource = DruidDataSourceFactory.createDataSource(map);
        }
        catch (Exception e) {
            log.warn("[DruidDataSourceConnector.createDataSource]_fail_\u6570\u636e\u6e90\u521b\u5efa\u5931\u8d25\uff0c" + e.getMessage());
        }
        if (dataSource == null) {
            log.warn("[DruidDataSourceConnector.addDataSource]_warn: " + name + " \u52a8\u6001\u6570\u636e\u6e90\u6dfb\u52a0\u5931\u8d25");
            return;
        }
        log.warn("[DruidDataSourceConnector.addDataSource]_warn: " + name + " \u52a8\u6001\u6570\u636e\u6e90\u6dfb\u52a0\u6210\u529f");
        ManateeDataSource.addDataSource(name, dataSource);
    }

    private static Boolean isDbAlreadyExist(String name, String username, String password, String url) {
        if ("default".equals(name)) {
            throw new RuntimeException("\u9ed8\u8ba4\u4e3b\u6570\u636e\u6e90\u4e0d\u53ef\u8986\u76d6\u548c\u6dfb\u52a0");
        }
        if (ManateeDataSource.getDataSourceNameSet().contains(name)) {
            DruidDataSource oldDataSource = (DruidDataSource)ManateeDataSource.dataSourceMap.get(name);
            StringBuilder oldDataSourceSb = new StringBuilder();
            oldDataSourceSb.append(oldDataSource.getUrl()).append(oldDataSource.getUsername()).append(oldDataSource.getPassword());
            StringBuilder newDataSourceSb = new StringBuilder();
            newDataSourceSb.append(url).append(username).append(password);
            if (oldDataSourceSb.toString().equals(newDataSourceSb.toString())) {
                return true;
            }
            return false;
        }
        return false;
    }
}

