/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.rest.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.domain.ModularityRequest;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.CacheRamUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RestModularityProcess
implements IProcess {
    private static final Long UPDATE_TIME = 99999L;
    private static Logger LOGGER = LoggerFactory.getLogger(RestModularityProcess.class);
    @Autowired
    private LoadBalancerClient loadBalancerClient;
    @Resource
    private CacheRamUtil cacheRamUtil;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource(name="manateeRestTemplate")
    private RestTemplate restTemplate;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        Object requestBody;
        String url = this.variableUtil.calVarInConf(content, "url");
        String service = this.variableUtil.calVarInConf(content, "service");
        String resultClassName = this.variableUtil.calVarInConf(content, "class");
        Boolean isLocal = content.getStepConf().getBoolean("isLocal");
        String reqMethod = content.getStepConf().getString("requestType");
        MultiValueMap<String, String> requestHeaders = RestModularityProcess.getRequestHeaders(content);
        HttpEntity requestEntity = null;
        StringBuilder urlStrBuilder = new StringBuilder(url);
        LOGGER.debug("rest isLocal:{}, url:{},reqMethod:{}, service:{},", new Object[]{isLocal, url, reqMethod, service});
        if (isLocal != null && !isLocal.booleanValue()) {
            boolean addparamToUrl;
            requestBody = this.getJsonBody(content);
            requestHeaders.set((Object)"Content-Type", (Object)"application/json");
            Map<String, Object> queryParams = this.getQueryParams(content);
            requestEntity = StrUtil.isBlank((CharSequence)reqMethod) || "post".equals(reqMethod) ? new HttpEntity(requestBody, requestHeaders) : new HttpEntity(requestHeaders);
            boolean bl = addparamToUrl = queryParams != null || "get".equals(reqMethod);
            if (addparamToUrl) {
                for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                    if (urlStrBuilder.indexOf("?") == -1) {
                        urlStrBuilder.append("?");
                    } else {
                        urlStrBuilder.append("&");
                    }
                    urlStrBuilder.append((Object)entry.getKey()).append("=").append(entry.getValue());
                }
            }
        } else {
            requestBody = this.getRequest(content);
            requestEntity = new HttpEntity(requestBody, requestHeaders);
        }
        Class<?> resultClass = ModularityResult.class;
        if (StrUtil.isNotBlank((CharSequence)resultClassName)) {
            try {
                resultClass = (Class<?>)this.cacheRamUtil.getCache(resultClassName);
                if (resultClass == null) {
                    resultClass = Class.forName(resultClassName);
                    this.cacheRamUtil.setCache(resultClassName, resultClass, UPDATE_TIME);
                }
            }
            catch (ClassNotFoundException e) {
                throw new BizException(ResultCode.SYSTEM_ERROR, String.format("\u8fd4\u56de\u7ed3\u679c\u7c7b\u3010%s\u3011\u672a\u627e\u5230", resultClassName));
            }
        }
        Object o = this.doRequest(service, urlStrBuilder.toString(), requestEntity, resultClass, reqMethod);
        this.outputUtil.putData(content, JSONObject.toJSON(o));
    }

    private static MultiValueMap<String, String> getRequestHeaders(ProcessContent content) {
        Map header;
        LinkedMultiValueMap requestHeaders = new LinkedMultiValueMap();
        if (((Boolean)content.getStepConf("passHeader")).booleanValue() && CollUtil.isNotEmpty((Map)(header = content.getHeader()))) {
            for (Map.Entry stringObjectEntry : header.entrySet()) {
                if (StrUtil.equals((CharSequence)((CharSequence)stringObjectEntry.getKey()), (CharSequence)"Content-Length")) continue;
                requestHeaders.set(stringObjectEntry.getKey(), (Object)stringObjectEntry.getValue().toString());
            }
        }
        return requestHeaders;
    }

    private Map<String, Object> getQueryParams(ProcessContent content) throws BizException {
        Map params = this.inputUtil.getHandleObject(content, "queryParams");
        return params;
    }

    private ModularityRequest getRequest(ProcessContent content) throws BizException {
        Map params = this.inputUtil.getHandleObject(content);
        ModularityRequest request = new ModularityRequest();
        request.setParams(params);
        request.setTraceId(content.getTraceId());
        request.setUserId(content.getUserId());
        return request;
    }

    private String getJsonBody(ProcessContent content) throws BizException {
        String bodyType = content.getStepConfString("bodyType");
        Object params = null;
        if (StrUtil.isBlank((CharSequence)bodyType) || "map".equals(bodyType)) {
            params = this.inputUtil.getHandleObject(content, "body");
        } else {
            String key = this.variableUtil.calVarInConf(content, "bodyValue");
            params = content.getValue(key);
        }
        return JSONObject.toJSONString((Object)params);
    }

    public <T> T doRequest(String service, String url, HttpEntity request, Class<T> aClass, String reqMethod) throws BizException {
        ServiceInstance instance = this.loadBalancerClient.choose(service);
        if (instance == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, String.format("\u670d\u52a1\u3010%s\u3011\u672a\u627e\u5230", service));
        }
        String serviceUrl = String.format("http://%s:%s", instance.getHost(), instance.getPort()) + "/" + url;
        try {
            if (StrUtil.isBlank((CharSequence)reqMethod) || "post".equals(reqMethod)) {
                return (T)this.restTemplate.postForObject(serviceUrl, (Object)request, aClass, new Object[0]);
            }
            return (T)this.restTemplate.exchange(serviceUrl, HttpMethod.GET, request, aClass, new Object[0]).getBody();
        }
        catch (RuntimeException e) {
            LOGGER.debug("reqMethod\u3010{}\u3011,serviceUrl:\u3010{}\u3011,request:\u3010{}\u3011,msg:\u3010{}\u3011", new Object[]{reqMethod, serviceUrl, JSONObject.toJSONString((Object)request), e.getMessage()});
            throw e;
        }
    }

    public String getName() {
        return "restProcess";
    }
}

