/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.performance.base;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.manager.SpringContextManager;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.execute.DebugUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentThreadV2
implements Runnable {
    private Logger log = LoggerFactory.getLogger(ConcurrentThreadV2.class);
    private ProcessContent contentTemp;
    private ProcessContent content;
    private JSONObject stepConf;
    private CountDownLatch latch;

    public ConcurrentThreadV2(ProcessContent content, ProcessContent contentTemp, JSONObject stepConf, CountDownLatch latch) {
        this.content = content;
        this.contentTemp = contentTemp;
        this.latch = latch;
        this.stepConf = stepConf;
    }

    @Override
    public void run() {
        try {
            List steps = ProcessDataSource.formatSteps((JSONObject)this.stepConf);
            ProcessChain processChain = (ProcessChain)SpringContextManager.getBean((String)"processChain");
            processChain.executeSteps(this.contentTemp, steps);
            if (DebugUtil.isDebug((ProcessContent)this.content) && this.contentTemp.getDebug() != null) {
                Set executeNodeIds;
                List executeSqlList = this.contentTemp.getDebug().getExecuteSqls();
                if (executeSqlList != null && executeSqlList.size() > 0) {
                    for (JSONObject jsonObject : executeSqlList) {
                        this.content.getDebug().putExecuteSqls(jsonObject);
                    }
                }
                if ((executeNodeIds = this.contentTemp.getDebug().getExecuteNodeIds()) != null && executeNodeIds.size() > 0) {
                    for (String executeNodeId : executeNodeIds) {
                        this.content.getDebug().putExecuteNodeIds(executeNodeId);
                    }
                }
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
        catch (BizException e) {
            this.log.error("[ConcurrentThread.run]_exception", (Throwable)e);
        }
    }
}

