CREATE TABLE `lowcode_module_run_log`
(
    `id`             bigint(20) NOT NULL AUTO_INCREMENT COMMENT '日志主键',
    `trace_id`       varchar(64)   NOT NULL DEFAULT '' COMMENT '链路追踪编号',
    `user_id`        bigint(20) DEFAULT NULL COMMENT '用户编号',
    `project_id`     bigint(20) NOT NULL DEFAULT '0' COMMENT '项目id',
    `module_code`    varchar(100)  NOT NULL DEFAULT '' COMMENT '英文名称',
    `type`           varchar(50)            DEFAULT NULL COMMENT '操作模块类型',
    `sub_type`       varchar(50)            DEFAULT NULL COMMENT '操作名',
    `biz_id`         bigint(20) NOT NULL COMMENT '操作数据模块编号',
    `action`         varchar(2000) NOT NULL DEFAULT '' COMMENT '操作内容',
    `extra`          varchar(2000)          DEFAULT '' COMMENT '拓展字段',
    `request_method` varchar(16)            DEFAULT '' COMMENT '请求方法名',
    `request_url`    varchar(255)           DEFAULT '' COMMENT '请求地址',
    `user_ip`        varchar(50)            DEFAULT NULL COMMENT '用户 IP',
    `user_agent`     varchar(200)           DEFAULT NULL COMMENT '浏览器 UA',
    `create_user`    bigint(20) DEFAULT '0' COMMENT '创建用户id',
    `gmt_create`     datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `modified_user`  bigint(20) DEFAULT '0' COMMENT '更新用户id',
    `gmt_modified`   datetime      NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    `valid`          tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态\n-1 删除  \n0 正常',
    `tenant_id`      bigint(20) DEFAULT '0' COMMENT '租户编号',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='操作日志记录 V2 版本';