/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.manatee.common.util.SerializeUtil;
import com.manatee.redis.util.RedisClusterClientInit;
import com.manatee.redis.util.RedisClusterReadUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

@Service
public class RedisClusterWriteUtil {
    private final Logger log = LoggerFactory.getLogger(RedisClusterWriteUtil.class);
    @Resource
    private RedisClusterClientInit redisClusterClientInit;
    @Resource
    private RedisClusterReadUtil redisClusterReadUtil;

    public int setValue(String key, String json) {
        return this.setValue(0, key, json);
    }

    public int setValue(int db, String key, String json) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        int ret = 0;
        if (jedis != null) {
            try {
                jedis.set(key, json);
                ret = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long incr(int db, String key) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        int ret = 0;
        if (jedis != null) {
            try {
                return jedis.incr(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public int setex(String key, String value, int seconds) {
        return this.setex(0, key, value, seconds);
    }

    public int setex(int db, String key, String value, int seconds) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        int ret = 0;
        if (jedis != null) {
            try {
                jedis.setex(key, seconds, value);
                ret = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long hdelValue(int db, String key, String ... field) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.hdel(key, field);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long hsetValue(int db, String key, String field, String value) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.hset(key, field, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String hmsetValue(int db, String key, Map<String, String> fields) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        String ret = "";
        if (jedis != null) {
            try {
                ret = jedis.hmset(key, fields);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private List<String> hmgetValue(Jedis jedis, int db, String objectName, String ... fields) {
        List values = null;
        if (jedis != null) {
            values = jedis.hmget(objectName, fields);
        }
        return values;
    }

    private Map<String, String> hmgetAll(Jedis jedis, int db, String objectName) {
        Map valueMap = null;
        if (jedis != null) {
            valueMap = jedis.hgetAll(objectName);
        }
        return valueMap;
    }

    private Map<String, Object> list2LinkedMap(String[] fields, List<String> values) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i];
            String value = values.get(i);
            if (value == null) continue;
            result.put(fieldName, value);
        }
        return result;
    }

    public long delValue(int db, String key) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.del(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long delValue(int db, String[] keys) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.del(keys);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long delKeys(int db, String pattern) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                int count = 1000;
                List<String> setkeys = this.redisClusterReadUtil.scan(jedis, pattern, count);
                if (!setkeys.isEmpty()) {
                    String[] keys = setkeys.toArray(new String[setkeys.size()]);
                    jedis.del(keys);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public int setValue(byte[] key, Object obj) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        int ret = 0;
        if (jedis != null) {
            try {
                jedis.set(key, SerializeUtil.serialize((Object)obj));
                ret = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long delValue(byte[] key) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.del(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long lpushList(String key, String json) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.lpush(key, new String[]{json});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long lpushList(int db, String key, String[] values) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.lpush(key, values);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long rpushList(String key, String json) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.rpush(key, new String[]{json});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long lpushList(String key, String[] values) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.lpush(key, values);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public long rpushList(String key, String[] values) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long ret = 0L;
        if (jedis != null) {
            try {
                ret = jedis.rpush(key, values);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private static void putResult(String key, Map<String, String> resultMap, List<Map.Entry<String, String>> entryList) {
        for (Map.Entry<String, String> entry : entryList) {
            String entryKey = entry.getKey();
            String entryValue = entry.getValue();
            resultMap.put(entryKey, entryValue);
        }
        resultMap.put("keyCount", entryList.size() + "");
        if (key.contains(":")) {
            String primaryKey = key.substring(key.lastIndexOf(":"));
            resultMap.put("primaryKey", primaryKey);
        }
    }

    public long sadd(int db, String key, String ... members) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.sadd(key, members);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public long zadd(int db, String key, double score, String member) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.zadd(key, score, member);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public long zadd(int db, String key, Map<String, Double> scoreMembers) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.zadd(key, scoreMembers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public double zincrby(int db, String key, double score, String member) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        double result = 0.0;
        if (jedis != null) {
            try {
                result = jedis.zincrby(key, score, member);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public long expire(int db, String key, int seconds) {
        JedisCluster jedis = this.redisClusterClientInit.getWritePoolInstance();
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.expire(key, seconds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

