/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.CacheRamUtil;
import com.manatee.redis.domain.CacheBO;
import com.manatee.redis.source.DtSourceManager;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ManateeCacheUtil {
    private String KEY_PREFIX = "lowcodeCache:";
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private CacheRamUtil cacheRamUtil;

    public Object getCache(CacheBO cacheBO) {
        if ("ram".equals(cacheBO.getType())) {
            return this.cacheRamUtil.getCache(cacheBO.getKey());
        }
        return this.getCacheFromRedis(cacheBO.getDb(), cacheBO.getKey());
    }

    private Object getCacheFromRedis(int db, String key) {
        key = this.KEY_PREFIX + key;
        String value = this.dtSourceManager.getDtSource().getValue(db, key);
        return StringUtil.jsonParse((String)value);
    }

    private void setCacheWithRedis(CacheBO cacheBO) {
        String key = this.KEY_PREFIX + cacheBO.getKey();
        String str = JSONObject.toJSONString((Object)cacheBO.getValue());
        Integer second = cacheBO.getMinute() * 60;
        this.dtSourceManager.getDtSource().setex(cacheBO.getDb(), key, str, second);
    }

    public void setCache(CacheBO cacheBO) {
        if ("ram".equals(cacheBO.getType())) {
            this.cacheRamUtil.setCache(cacheBO.getKey(), cacheBO.getValue(), cacheBO.getMinute());
        } else {
            this.setCacheWithRedis(cacheBO);
        }
    }
}

