/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.source;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.redis.domain.DtFuzzyQuery;
import com.manatee.redis.domain.DtHashDO;
import com.manatee.redis.domain.DtQuery;
import com.manatee.redis.domain.DtTopQuery;
import com.manatee.redis.source.IDtSource;
import com.manatee.redis.util.RedisClusterReadUtil;
import com.manatee.redis.util.RedisClusterWriteUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="redisClusterDtSource")
public class RedisClusterDtSourceImpl
implements IDtSource {
    @Resource
    private RedisClusterReadUtil redisClusterReadUtil;
    @Resource
    private RedisClusterWriteUtil redisClusterWriteUtil;
    private Logger log = LoggerFactory.getLogger(RedisClusterDtSourceImpl.class);

    @Override
    public Map<String, Object> query(DtQuery dtQuery) throws BizException {
        List<String> fieldList = dtQuery.getHashKeys();
        String[] fields = fieldList.toArray(new String[fieldList.size()]);
        String key = this.getKey(dtQuery);
        if (this.isAllKey(fields)) {
            return this.queryAll(dtQuery, key);
        }
        return this.redisClusterReadUtil.hmgetValue(dtQuery.getDbIndex(), key, fields);
    }

    @Override
    public long queryTtl(DtQuery dtQuery) throws BizException {
        String key = this.getKey(dtQuery);
        return this.redisClusterReadUtil.getTtl(dtQuery.getDbIndex(), key);
    }

    private Map<String, Object> queryAll(DtQuery dtQuery, String key) {
        Map<String, String> map = this.redisClusterReadUtil.hmgetAll(dtQuery.getDbIndex(), key);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> maps : map.entrySet()) {
            result.put(maps.getKey(), maps.getValue());
        }
        return result;
    }

    @Override
    public Long incr(DtQuery dtQuery) {
        return this.redisClusterWriteUtil.incr(dtQuery.getDbIndex(), dtQuery.getKey());
    }

    @Override
    public List<String> queryMembers(DtQuery dtQuery) {
        Set<String> set = this.redisClusterReadUtil.smembers(dtQuery.getDbIndex(), dtQuery.getKey());
        ArrayList<String> list = new ArrayList<String>(set);
        return list;
    }

    private boolean isAllKey(String[] fields) {
        if (fields.length != 1) {
            return false;
        }
        String field = fields[0];
        return "*".equals(field);
    }

    private String getKey(DtQuery dtQuery) throws BizException {
        List<String> keys = dtQuery.getKeys();
        if (keys == null || keys.size() == 0) {
            throw new BizException(ResultCode.BIZ_ERROR, "query_key_is_null");
        }
        return keys.get(0);
    }

    @Override
    public List<Map<String, Object>> batchQuery(DtQuery dtQuery) {
        List<String> hashList = dtQuery.getHashKeys();
        String[] fields = new String[hashList.size()];
        hashList.toArray(fields);
        List<String> keys = dtQuery.getKeys();
        int db = dtQuery.getDbIndex();
        ArrayList<Map<String, Object>> result = new ArrayList();
        try {
            result = this.redisClusterReadUtil.hmgetBatchValue(db, keys, fields);
        }
        catch (Exception e) {
            this.log.error("[RedisDtSourceImpl.batchQuery]_exception", (Throwable)e);
        }
        return result;
    }

    @Override
    public JSONArray batchQueryValue(DtQuery dtQuery) {
        List<String> keylist = dtQuery.getKeys();
        if (keylist == null) {
            this.log.error("[RedisDtSourceImpl.batchQueryValue]_biz_error,dtQuery:{},msg:{}", (Object)JSON.toJSONString((Object)dtQuery), (Object)"keylist_is_null");
        }
        int db = dtQuery.getDbIndex();
        JSONArray result = new JSONArray();
        try {
            String[] keys = new String[keylist.size()];
            keylist.toArray(keys);
            List<String> list = this.getListString(dtQuery, db, keys);
            for (String str : list) {
                if (str == null) continue;
                String obj = str.startsWith("{") && str.endsWith("}") ? JSON.parseObject((String)str, (Feature[])new Feature[]{Feature.OrderedField}) : str;
                result.add((Object)obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> getListString(DtQuery dtQuery, int db, String[] keys) {
        return this.redisClusterReadUtil.getValues(db, keys);
    }

    @Override
    public List<String> queryTop(DtTopQuery dtTopQuery) {
        int db = dtTopQuery.getDbIndex();
        String key = dtTopQuery.getKey();
        long start = dtTopQuery.getStart();
        long end = dtTopQuery.getEnd();
        Set<String> set = this.redisClusterReadUtil.zrevrange(db, key, start, end);
        ArrayList<String> result = new ArrayList<String>(set);
        return result;
    }

    @Override
    public Map<String, Double> queryTopWithScore(DtTopQuery dtQuery) {
        int db = dtQuery.getDbIndex();
        String key = dtQuery.getKey();
        long start = dtQuery.getStart();
        long end = dtQuery.getEnd();
        String orderType = dtQuery.getOrderType();
        if (orderType == null) {
            orderType = "desc";
        }
        Map<String, Double> valueMap = new LinkedHashMap<String, Double>();
        if ("desc".equals(orderType)) {
            valueMap = this.redisClusterReadUtil.zrevrangeWithScores(db, key, start, end);
        } else if ("asc".equals(orderType)) {
            valueMap = this.redisClusterReadUtil.zrangeWithScores(db, key, start, end);
        }
        return valueMap;
    }

    @Override
    public List<String> fuzzyQuery(DtFuzzyQuery dtQuery) {
        String pattern = dtQuery.getPattern();
        int limit = dtQuery.getLimit();
        int db = dtQuery.getDbIndex();
        return this.redisClusterReadUtil.scanLimitForSear(pattern, limit, db);
    }

    @Override
    public List<String> fuzzySearch(DtFuzzyQuery dtQuery) {
        String pattern = dtQuery.getPattern();
        int limit = dtQuery.getLimit();
        int db = dtQuery.getDbIndex();
        return this.redisClusterReadUtil.scanLimit(pattern, limit, db);
    }

    @Override
    public Long insertHash(DtHashDO dtHashDO) {
        int db = dtHashDO.getDbIndex();
        String key = dtHashDO.getKey();
        String field = dtHashDO.getField();
        String value = dtHashDO.getValue();
        return this.redisClusterWriteUtil.hsetValue(db, key, field, value);
    }

    @Override
    public Long hdelValue(Integer dbIndex, String key, String ... field) {
        return this.redisClusterWriteUtil.hdelValue(dbIndex, key, field);
    }

    @Override
    public Long delValue(int db, String key) {
        return this.redisClusterWriteUtil.delValue(db, key);
    }

    @Override
    public String insertMultiFieldHash(DtHashDO dtHashDO) {
        int db = dtHashDO.getDbIndex();
        String key = dtHashDO.getKey();
        Map<String, String> fields = dtHashDO.getFields();
        return this.redisClusterWriteUtil.hmsetValue(db, key, fields);
    }

    @Override
    public Integer insertValue(DtHashDO dtHashDO) {
        int db = dtHashDO.getDbIndex();
        String key = dtHashDO.getKey();
        String value = dtHashDO.getValue();
        Integer expTime = dtHashDO.getExpTime();
        Integer ret = null;
        ret = expTime == null ? Integer.valueOf(this.redisClusterWriteUtil.setValue(db, key, value)) : Integer.valueOf(this.redisClusterWriteUtil.setex(db, key, value, expTime));
        return ret;
    }

    @Override
    public Long expire(Integer db, String key, Integer seconds) {
        return this.redisClusterWriteUtil.expire(db, key, seconds);
    }

    @Override
    public Long lpushList(Integer db, String key, String[] values) {
        return this.redisClusterWriteUtil.lpushList(db, key, values);
    }

    @Override
    public Long sadd(Integer db, String key, String ... members) {
        return this.redisClusterWriteUtil.sadd(db, key, members);
    }

    @Override
    public Integer setex(Integer db, String key, String value, Integer seconds) {
        return this.redisClusterWriteUtil.setex(db, key, value, seconds);
    }

    @Override
    public Map<String, String> hscan(String key, String pattern, Integer count, Integer db) {
        return this.redisClusterReadUtil.hscan(key, pattern, count, (int)db);
    }

    @Override
    public String getValue(int db, String key) {
        return this.redisClusterReadUtil.getValue(db, key);
    }

    @Override
    public Map<String, Object> hmgetValue(Integer db, String objectName, String ... fields) {
        return this.redisClusterReadUtil.hmgetValue(db, objectName, fields);
    }

    @Override
    public Boolean exists(Integer db, String key) {
        return this.redisClusterReadUtil.exists(db, key);
    }

    @Override
    public List<String> getList(Integer db, String key, Long start, Long end) {
        return this.redisClusterReadUtil.getList(db, key, start, end);
    }

    @Override
    public Set<String> smembers(Integer db, String key) {
        return this.redisClusterReadUtil.smembers(db, key);
    }

    @Override
    public Set<String> zrange(Integer db, String key, long start, long end) {
        return this.redisClusterReadUtil.zrange(db, key, start, end);
    }
}

