/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.domain.DtFuzzyQuery;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisKeysFuzzyQueryProcess
implements IProcess {
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    private Logger log = LoggerFactory.getLogger(RedisKeysFuzzyQueryProcess.class);

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"pattern"});
        String pattern = conf.getString("pattern");
        pattern = this.variableUtil.calVar(content, pattern);
        List<String> valueList = this.getValueList(pattern, content);
        if (valueList == null || valueList.size() == 0) {
            this.log.warn("[FuzzySearchProcess.process]_biz_occur,code:{},msg:{}", content.getRequest("lowcodeModule"), (Object)"fuzzyQuery is null");
            throw new BizException(ResultCode.RESULT_IS_NULL, "result_is_null");
        }
        Collections.sort(valueList);
        this.outputUtil.handleAndPutData(content, valueList);
        this.log.warn("[FuzzySearchProcess.process]_biz_success,code:{},msg:{}", content.getRequest("lowcodeModule"), (Object)"fuzzyQuery success");
    }

    private List<String> getValueList(String pattern, ProcessContent content) {
        JSONObject conf = content.getStepConf();
        int limit = conf.getIntValue("limit");
        int db = RedisDbUtil.getRedisDB(content);
        DtFuzzyQuery dtFuzzyQuery = new DtFuzzyQuery(db, limit, pattern);
        if (conf.containsKey((Object)"isStaticRedis")) {
            dtFuzzyQuery.setStaticRedis(conf.getBoolean("isStaticRedis"));
        }
        return this.dtSourceManager.getDtSource().fuzzySearch(dtFuzzyQuery);
    }

    public String getName() {
        return "redisKeysFuzzyQuery";
    }
}

