/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisHashFieldsFuzzyQueryProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RedisHashFieldsFuzzyQueryProcess.class);
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        Map<String, String> resultMap;
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key", "pattern"});
        int db = RedisDbUtil.getRedisDB(content);
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        String pattern = conf.getString("pattern");
        int count = 1000;
        if (conf.containsKey((Object)"count")) {
            count = conf.getInteger("count");
        }
        if ((resultMap = this.dtSourceManager.getDtSource().hscan(objectKey, pattern, count, db)) == null || resultMap.isEmpty()) {
            this.log.warn("[GetRedisHashFieldsProcess.process]_biz_occur,msg:{}", (Object)("result_is_null,key:" + objectKey + ",pattern:" + pattern));
            throw new BizException(ResultCode.RESULT_IS_NULL, "result_is_null");
        }
        this.outputUtil.handleAndPutData(content, resultMap);
        this.log.warn("[GetRedisHashFieldsProcess.process]_biz_occur,msg:{}", (Object)("object_key:" + objectKey + ",pattern:" + pattern));
    }

    public String getName() {
        return "redisHashFieldsFuzzyQuery";
    }
}

