/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.postgresql.store;

import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PostgresqlCountProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        Integer totalCount;
        this.processConfUtil.checkConf(content, new String[]{"table"});
        DBQuery dbQuery = this.dBManager.getDBQuery(content, "postgresql");
        dbQuery.setSelectTotalCount(Boolean.valueOf(true));
        try {
            totalCount = this.dbReadUtil.findCount(dbQuery);
        }
        catch (BizException e) {
            throw e;
        }
        finally {
            this.dBManager.logExecuteSql(content, dbQuery.getExecuteSql());
        }
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)totalCount);
    }

    public String getName() {
        return "postgreSqlCount";
    }
}

