/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.manager.MinioManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.ProcessFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MinioFileProcess
implements IProcess {
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private MinioManager minioManager;
    private final String UPLOAD = "upload";
    private final String DOWNLOAD = "download";
    private final String REMOVE = "remove";
    private final String GET_URL = "getUrl";
    private final String CHUNK_UPLOAD = "chunkUpload";
    private final String MERGE_CHUNK = "mergeChunk";

    public void process(ProcessContent content) throws BizException {
        String action = this.variableUtil.calVarInConf(content, "action");
        if (StringUtils.equals((CharSequence)action, (CharSequence)"upload")) {
            this.uploadFile(content);
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)"download")) {
            this.downloadFile(content);
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)"remove")) {
            this.removeFile(content);
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)"getUrl")) {
            this.getUrl(content);
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)"chunkUpload")) {
            this.chunkUploadFile(content);
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)"mergeChunk")) {
            this.mergeChunk(content);
        }
    }

    private void uploadFile(ProcessContent content) throws BizException {
        JSONObject result;
        String fileSource = content.getStepConfString("fileSource");
        InputStream file = null;
        String fileName = null;
        Object base64Value = null;
        List fileInfoList = null;
        if (StringUtils.isBlank((CharSequence)fileSource) || StringUtils.equals((CharSequence)fileSource, (CharSequence)"param")) {
            file = content.getFile();
            fileName = content.getFileName();
            String base64Key = this.variableUtil.calVarInConf(content, "base64");
            base64Value = content.getValue(base64Key);
            fileInfoList = content.getFiles();
        }
        String localFilePath = null;
        if (StringUtils.isBlank((CharSequence)fileSource) || StringUtils.equals((CharSequence)fileSource, (CharSequence)"local")) {
            localFilePath = this.variableUtil.calVarInConf(content, "localFilePath");
        }
        String bucketName = this.variableUtil.calVarInConf(content, "bucketName");
        String folder = this.variableUtil.calVarInConf(content, "folder");
        Boolean autoCover = content.getStepConf().getBoolean("autoCover");
        if (file != null) {
            result = this.minioManager.uploadFile(fileName, file, bucketName, folder, autoCover, false, null);
        } else if (fileInfoList != null && fileInfoList.size() > 0) {
            JSONArray urls = new JSONArray();
            for (ProcessFileInfo processFileInfo : fileInfoList) {
                InputStream fileInfo = processFileInfo.getInputStream();
                String fileInfoName = processFileInfo.getFileName();
                JSONObject resultTemp = this.minioManager.uploadFile(fileInfoName, fileInfo, bucketName, folder, autoCover, false, null);
                urls.add((Object)resultTemp);
            }
            result = urls;
        } else if (base64Value != null && StringUtil.isNotBlank((String)base64Value.toString())) {
            String[] base64Array = base64Value.toString().split(StrSplit.FH);
            String base = base64Array[1].split(StrSplit.D)[1];
            String suffix = base64Array[0].split("/")[1];
            result = this.minioManager.uploadFileBase(base, bucketName, folder, suffix, autoCover, false, null, null);
        } else if (StringUtil.isNotBlank((String)localFilePath)) {
            FileInputStream inputStream;
            Boolean needDel = content.getStepConf().getBoolean("needDel");
            File fileTemp = new File(localFilePath);
            try {
                inputStream = new FileInputStream(fileTemp);
            }
            catch (FileNotFoundException e) {
                BizException bizException = new BizException(ResultCode.PARAM_IS_ERROR, "file not found", (Throwable)e);
                bizException.setInterrupt(Integer.valueOf(3));
                throw bizException;
            }
            result = this.minioManager.uploadFile(fileTemp.getName(), inputStream, bucketName, folder, autoCover, false, null);
            if (needDel != null && fileTemp != null && needDel.booleanValue() && fileTemp.exists()) {
                fileTemp.delete();
            }
        } else {
            BizException bizException = new BizException(ResultCode.PARAM_IS_ERROR, "file/base64 \u672a\u586b");
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        this.outputUtil.setDefaultReturnKey(content, "outputData");
        this.outputUtil.putData(content, (Object)result);
    }

    private void downloadFile(ProcessContent content) throws BizException {
        String bucketName = this.variableUtil.calVarInConf(content, "bucketName");
        String minioFile = this.variableUtil.calVarInConf(content, "minioFile");
        String downloadFile = this.variableUtil.calVarInConf(content, "downloadFile");
        String url = this.minioManager.downloadFile(bucketName, minioFile, downloadFile);
        this.outputUtil.setDefaultReturnKey(content, "lowcodeFileUrl");
        this.outputUtil.putData(content, (Object)url);
    }

    private void removeFile(ProcessContent content) throws BizException {
        String bucketName = this.variableUtil.calVarInConf(content, "bucketName");
        String minioFile = this.variableUtil.calVarInConf(content, "minioFile");
        this.minioManager.removeFile(bucketName, minioFile);
    }

    private void getUrl(ProcessContent content) throws BizException {
        String bucketName = this.variableUtil.calVarInConf(content, "bucketName");
        String minioFile = this.variableUtil.calVarInConf(content, "minioFile");
        String url = this.minioManager.getUrl(bucketName, minioFile);
        this.outputUtil.setDefaultReturnKey(content, "outputData");
        this.outputUtil.putData(content, (Object)url);
    }

    private void chunkUploadFile(ProcessContent content) throws BizException {
        JSONObject result;
        String fileSource = content.getStepConfString("fileSource");
        InputStream file = null;
        Object base64Value = null;
        if (StringUtils.isBlank((CharSequence)fileSource) || StringUtils.equals((CharSequence)fileSource, (CharSequence)"param")) {
            file = content.getFile();
            String base64Key = this.variableUtil.calVarInConf(content, "base64");
            base64Value = content.getValue(base64Key);
        }
        String localFilePath = null;
        if (StringUtils.isBlank((CharSequence)fileSource) || StringUtils.equals((CharSequence)fileSource, (CharSequence)"local")) {
            localFilePath = this.variableUtil.calVarInConf(content, "localFilePath");
        }
        String bucketName = this.variableUtil.calVarInConf(content, "bucketName");
        String folder = "chunk/temp";
        String chunkIndex = this.variableUtil.calVarInConf(content, "chunkIndex");
        String chunkIdentifier = this.variableUtil.calVarInConf(content, "chunkIdentifier");
        if (file != null) {
            result = this.minioManager.uploadFile(chunkIdentifier, file, bucketName, folder, false, true, chunkIndex);
        } else if (base64Value != null && StringUtil.isNotBlank((String)base64Value.toString())) {
            String[] base64Array = base64Value.toString().split(StrSplit.FH);
            String base = base64Array[1].split(StrSplit.D)[1];
            String suffix = base64Array[0].split("/")[1];
            result = this.minioManager.uploadFileBase(base, bucketName, folder, suffix, false, true, chunkIndex, chunkIdentifier);
        } else if (StringUtil.isNotBlank((String)localFilePath)) {
            FileInputStream inputStream;
            Boolean needDel = content.getStepConf().getBoolean("needDel");
            File fileTemp = new File(localFilePath);
            try {
                inputStream = new FileInputStream(fileTemp);
            }
            catch (FileNotFoundException e) {
                BizException bizException = new BizException(ResultCode.PARAM_IS_ERROR, "file not found", (Throwable)e);
                bizException.setInterrupt(Integer.valueOf(3));
                throw bizException;
            }
            result = this.minioManager.uploadFile(chunkIdentifier, inputStream, bucketName, folder, false, true, chunkIndex);
            if (needDel != null && fileTemp != null && needDel.booleanValue() && fileTemp.exists()) {
                fileTemp.delete();
            }
        } else {
            BizException bizException = new BizException(ResultCode.PARAM_IS_ERROR, "file/base64 \u672a\u586b");
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        this.outputUtil.setDefaultReturnKey(content, "outputData");
        this.outputUtil.putData(content, (Object)result);
    }

    private void mergeChunk(ProcessContent content) throws BizException {
        String bucketName = this.variableUtil.calVarInConf(content, "bucketName");
        String folder = this.variableUtil.calVarInConf(content, "folder");
        String fileName = this.variableUtil.calVarInConf(content, "fileName");
        Boolean autoCover = content.getStepConf().getBoolean("autoCover");
        String chunkTotal = this.variableUtil.calVarInConf(content, "chunkTotal");
        String chunkIdentifier = this.variableUtil.calVarInConf(content, "chunkIdentifier");
        JSONObject result = this.minioManager.mergeChunk(bucketName, folder, fileName, autoCover, chunkTotal, chunkIdentifier);
        this.outputUtil.setDefaultReturnKey(content, "outputData");
        this.outputUtil.putData(content, (Object)result);
    }

    public String getName() {
        return "minioFileProcess";
    }
}

