/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.process.domain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.ResultTrace;
import com.manatee.common.domain.UnBlockError;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CollectionUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.process.domain.Step;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ErrorTrace
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6293047199177926826L;
    BizException thisException;
    List<BizException> exceptions = new ArrayList<BizException>();
    private List<UnBlockError> unBlockErrorList;
    JSONArray trace = new JSONArray();
    int interruptLevel;

    public void addUnBlockError(UnBlockError unBlockError) {
        if (Objects.isNull(unBlockError)) {
            return;
        }
        if (Objects.nonNull(this.unBlockErrorList)) {
            this.unBlockErrorList.add(unBlockError);
        } else {
            this.unBlockErrorList = new ArrayList<UnBlockError>();
            this.unBlockErrorList.add(unBlockError);
        }
    }

    public void addUnBlockErrorList(List<UnBlockError> unBlockErrorList) {
        if (CollectionUtils.isEmpty(unBlockErrorList)) {
            return;
        }
        if (Objects.nonNull(this.unBlockErrorList)) {
            this.unBlockErrorList.addAll(unBlockErrorList);
        } else {
            this.unBlockErrorList = new ArrayList<UnBlockError>();
            this.unBlockErrorList.addAll(unBlockErrorList);
        }
    }

    public List<UnBlockError> getUnBlockErrorList() {
        return this.unBlockErrorList;
    }

    public void addTrace(JSONObject aTrace) {
        if (aTrace == null) {
            return;
        }
        this.trace.add((Object)aTrace);
    }

    public void addException(Step step, Throwable e) {
        BizException bizException = null;
        if (e instanceof BizException) {
            bizException = (BizException)e;
        } else if (e instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException undeclare = (UndeclaredThrowableException)e;
            bizException = (BizException)undeclare.getUndeclaredThrowable();
        } else {
            bizException = new BizException(ResultCode.SYSTEM_ERROR, e);
        }
        if (step != null) {
            if (StringUtil.isBlank(bizException.getStepName())) {
                bizException.setStepName(step.getName());
            }
            if (StringUtil.isBlank(bizException.getId())) {
                bizException.setId(step.getId());
            }
            if (StringUtil.isBlank(bizException.getStepTitle())) {
                bizException.setStepTitle(step.getTitle());
            }
        }
        if (this.checkHave(bizException)) {
            return;
        }
        this.exceptions.add(bizException);
    }

    public void setExceptions(List<BizException> exceptionList) {
        if (exceptionList == null) {
            return;
        }
        if (exceptionList.size() == 0) {
            this.exceptions = exceptionList;
            this.interruptLevel = 0;
        }
        BizException lastException = null;
        for (BizException exception : exceptionList) {
            if (lastException == null) {
                lastException = exception;
                continue;
            }
            if (this.checkEqual(lastException, exception)) continue;
            this.exceptions.add(exception);
        }
    }

    private boolean checkHave(BizException e) {
        if (this.exceptions.size() == 0) {
            return false;
        }
        BizException last = this.exceptions.get(this.exceptions.size() - 1);
        return this.checkEqual(last, e);
    }

    private boolean checkEqual(BizException e1, BizException e2) {
        if (e1 == null || e2 == null) {
            return false;
        }
        if (!e1.getId().equals(e2.getId())) {
            return false;
        }
        if (!e1.getStepName().equals(e2.getStepName())) {
            return false;
        }
        if (!e1.getCode().equals(e2.getCode())) {
            return false;
        }
        if (e1.getSubCode() == null && e2.getSubCode() == null) {
            return true;
        }
        if (e1.getSubCode() == null) {
            return false;
        }
        return e1.getSubCode().equals(e2.getSubCode());
    }

    public BizException getException() {
        if (this.exceptions == null || this.exceptions.size() == 0) {
            return null;
        }
        return this.exceptions.get(this.exceptions.size() - 1);
    }

    public ResultTrace getResultTrace() {
        ResultTrace defaultResutTrace = new ResultTrace();
        if (this.exceptions == null || this.exceptions.size() == 0) {
            return defaultResutTrace;
        }
        if (this.interruptLevel == 3 || this.interruptLevel == 2) {
            BizException exception = this.getException();
            return exception.getResultTrace();
        }
        return defaultResutTrace;
    }

    public boolean isSuccess() {
        ResultTrace resultTrace = this.getResultTrace();
        return resultTrace.getId() >= 0;
    }

    public BizException getThisException() {
        return this.thisException;
    }

    public List<BizException> getExceptions() {
        return this.exceptions;
    }

    public JSONArray getTrace() {
        return this.trace;
    }

    public int getInterruptLevel() {
        return this.interruptLevel;
    }

    public void setThisException(BizException thisException) {
        this.thisException = thisException;
    }

    public void setUnBlockErrorList(List<UnBlockError> unBlockErrorList) {
        this.unBlockErrorList = unBlockErrorList;
    }

    public void setTrace(JSONArray trace) {
        this.trace = trace;
    }

    public void setInterruptLevel(int interruptLevel) {
        this.interruptLevel = interruptLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorTrace)) {
            return false;
        }
        ErrorTrace other = (ErrorTrace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BizException this$thisException = this.getThisException();
        BizException other$thisException = other.getThisException();
        if (this$thisException == null ? other$thisException != null : !this$thisException.equals(other$thisException)) {
            return false;
        }
        List<BizException> this$exceptions = this.getExceptions();
        List<BizException> other$exceptions = other.getExceptions();
        if (this$exceptions == null ? other$exceptions != null : !((Object)this$exceptions).equals(other$exceptions)) {
            return false;
        }
        List<UnBlockError> this$unBlockErrorList = this.getUnBlockErrorList();
        List<UnBlockError> other$unBlockErrorList = other.getUnBlockErrorList();
        if (this$unBlockErrorList == null ? other$unBlockErrorList != null : !((Object)this$unBlockErrorList).equals(other$unBlockErrorList)) {
            return false;
        }
        JSONArray this$trace = this.getTrace();
        JSONArray other$trace = other.getTrace();
        if (this$trace == null ? other$trace != null : !this$trace.equals(other$trace)) {
            return false;
        }
        return this.getInterruptLevel() == other.getInterruptLevel();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorTrace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BizException $thisException = this.getThisException();
        result = result * 59 + ($thisException == null ? 43 : $thisException.hashCode());
        List<BizException> $exceptions = this.getExceptions();
        result = result * 59 + ($exceptions == null ? 43 : ((Object)$exceptions).hashCode());
        List<UnBlockError> $unBlockErrorList = this.getUnBlockErrorList();
        result = result * 59 + ($unBlockErrorList == null ? 43 : ((Object)$unBlockErrorList).hashCode());
        JSONArray $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : $trace.hashCode());
        result = result * 59 + this.getInterruptLevel();
        return result;
    }

    public String toString() {
        return "ErrorTrace(thisException=" + this.getThisException() + ", exceptions=" + this.getExceptions() + ", unBlockErrorList=" + this.getUnBlockErrorList() + ", trace=" + this.getTrace() + ", interruptLevel=" + this.getInterruptLevel() + ")";
    }
}

