/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.io.resource;

import com.manatee.common.util.tool.core.io.IORuntimeException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.io.resource.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.tools.FileObject;

public class FileObjectResource
implements Resource {
    private final FileObject fileObject;

    public FileObjectResource(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public String getName() {
        return this.fileObject.getName();
    }

    @Override
    public URL getUrl() {
        try {
            return this.fileObject.toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public InputStream getStream() {
        try {
            return this.fileObject.openInputStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        try {
            return IoUtil.getReader(this.fileObject.openReader(false));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

