/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.manatee.common.domain.StrSplit;
import com.manatee.common.util.StrUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

public class FileUtil {
    public static boolean newFile(String fileName) {
        boolean result = true;
        File file = new File(fileName);
        if (!file.exists()) {
            try {
                result = file.createNewFile();
                System.out.println(file.getPath() + " created successfully...");
            }
            catch (IOException exp) {
                System.out.println("Error while creating file: " + exp);
            }
        }
        return result;
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static void deleteFiles(List<String> fileList) {
        for (String str : fileList) {
            FileUtil.deleteFile(str);
        }
    }

    public static String getNewFileName(Boolean autoCover, String filename) {
        if (autoCover != null && !autoCover.booleanValue()) {
            int suffixIndex = filename.lastIndexOf(StrSplit.P);
            suffixIndex = suffixIndex <= 0 ? filename.length() : suffixIndex;
            String relalName = filename.substring(0, suffixIndex);
            filename = relalName + UUID.randomUUID() + filename.substring(suffixIndex, filename.length());
        }
        return filename;
    }

    public static int lastIndexOfSeparator(String filePath) {
        if (StrUtils.isNotEmpty((String)filePath)) {
            int i = filePath.length();
            while (--i >= 0) {
                char c = filePath.charAt(i);
                if (!FileUtil.isFileSeparator(c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }
}

