/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.string;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class StrDesensitizeFun
extends AbstractFunction {
    private String name = "desensitize";
    private static final String REGEX_MOBILE_EXACT = "^(\\+?0?86\\-?)?1[345789]\\d{9}$";
    private static final String REGEX_TEL = "^(\\d{3,4}-)?\\d{6,8}$";
    private static final String REGEX_ID_CARD = "(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)";
    private static final String REGEX_EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    private static final String REGEX_NAME = "(^([\\u4e00-\u9fa5]{1,20}|[a-zA-Z\\.\\s]{1,20})$)|(^[\\u4e00-\\u9fa5]+\u00b7[\\u4e00-\\u9fa5]+$)";
    private static final String REGEX_ADDRESS = "(?<province>[^\u7701]+\u7701|.+\u81ea\u6cbb\u533a|[^\u6fb3\u95e8]+\u6fb3\u95e8|[^\u9999\u6e2f]+\u9999\u6e2f|[^\u5e02]+\u5e02)?(?<city>[^\u81ea\u6cbb\u5dde]+\u81ea\u6cbb\u5dde|[^\u7279\u522b\u884c\u653f\u533a]+\u7279\u522b\u884c\u653f\u533a|[^\u5e02]+\u5e02|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|\u5e02\u8f96\u533a|[^\u53bf]+\u53bf)(?<county>[^\u53bf]+\u53bf|[^\u5e02]+\u5e02|[^\u9547]+\u9547|[^\u533a]+\u533a|[^\u4e61]+\u4e61|.+\u573a|.+\u65d7|.+\u6d77\u57df|.+\u5c9b)?(?<address>.*)";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List parameters = content.getParameters();
        String str = parameters.get(0).toString();
        if (parameters.size() == 2 && parameters.get(1) != null) {
            return this.replaceString2Star(str, (Integer)parameters.get(1), 0);
        }
        if (parameters.size() == 3 && parameters.get(1) != null && parameters.get(2) != null) {
            return this.replaceString2Star(str, (Integer)parameters.get(1), (Integer)parameters.get(2));
        }
        return this.desensitize(str);
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 3;
    }

    private String desensitize(String str) {
        if (Pattern.matches(REGEX_MOBILE_EXACT, str)) {
            str = this.replaceString2Star(str, str.length() - 8, 4);
        } else if (Pattern.matches(REGEX_TEL, str)) {
            str = this.replaceString2Star(str, str.length() - 6, 2);
        } else if (Pattern.matches(REGEX_ID_CARD, str)) {
            str = this.replaceString2Star(str, 1, 2);
        } else if (Pattern.matches(REGEX_EMAIL, str)) {
            str = this.replaceString2Star(str, 1, str.length() - str.indexOf(64));
        } else if (Pattern.matches(REGEX_ADDRESS, str)) {
            Matcher m = Pattern.compile(REGEX_ADDRESS).matcher(str);
            int index = 3;
            if (m.find()) {
                String city = m.group("city");
                index = str.indexOf(city) + city.length();
            }
            str = this.replaceString2Star(str, index, 0);
        } else {
            str = Pattern.matches(REGEX_NAME, str) ? this.replaceString2Star(str, 1, str.length() > 2 ? 1 : 0) : this.replaceString2Star(str, 1, 2);
        }
        return str;
    }

    private String replaceString2Star(String content, int frontNum, int endNum) {
        if (content == null || content.trim().isEmpty()) {
            return content;
        }
        int len = content.length();
        if (frontNum >= len || frontNum < 0 || endNum >= len || endNum < 0) {
            return content;
        }
        if (frontNum + endNum >= len) {
            return content;
        }
        int beginIndex = frontNum;
        int endIndex = len - endNum;
        char[] cardChar = content.toCharArray();
        for (int j = beginIndex; j < endIndex; ++j) {
            cardChar[j] = 42;
        }
        return new String(cardChar);
    }
}

