/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.rabbitmq.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;

@Service
public class RabbitmqProducerProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RabbitmqProducerProcess.class);
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    private RabbitTemplate rabbitTemplate;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"topic"});
        String topic = this.variableUtil.calVarInConf(content, "topic");
        String tags = this.variableUtil.calVarInConf(content, "tags");
        String uniqueid = this.variableUtil.calVarInConf(content, "uniqueid");
        Map value = this.inputUtil.getHandleObject(content, "value");
        JSONObject valueJson = new JSONObject(true);
        valueJson.putAll(value);
        if (StringUtil.isNotBlank((String)uniqueid)) {
            valueJson.put("_uniqueid", (Object)uniqueid);
        }
        if (StringUtil.isNotBlank((String)topic)) {
            valueJson.put("_topic", (Object)topic);
        }
        if (StringUtil.isNotBlank((String)tags)) {
            valueJson.put("_tags", (Object)tags);
        }
        try {
            this.rabbitTemplate.convertAndSend("manatee_message_queue", (Object)valueJson.toJSONString());
            this.log.warn("rabbitmq producer success");
        }
        catch (Exception e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "rabbitmq producer error");
        }
    }

    public String getName() {
        return "rabbitmqProducer";
    }
}

