/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.dal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.TimeUtil;
import com.manatee.lowcode.dal.ManateeGraphDo;
import com.manatee.lowcodedb.base.DBReadUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ManateeGraphDao {
    @Resource
    private DBReadUtil dbReadUtil;
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;

    public List<ManateeGraphDo> findGraphByBizType(Long projectId, Integer bizType, Date gmtModified) throws BizException {
        DBQuery moduleDbQuery = new DBQuery();
        moduleDbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
        moduleDbQuery.setTable("lowcode_base_graphs");
        moduleDbQuery.setCamelCase(Boolean.valueOf(true));
        moduleDbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Number> moduleConditionMap = new HashMap<String, Number>();
        moduleConditionMap.put("project_id", projectId);
        moduleConditionMap.put("biz_type", bizType);
        if (gmtModified != null) {
            moduleDbQuery.setCondition("gmt_modified > '" + TimeUtil.format2Date((Date)gmtModified, (String)"yyyy-MM-dd HH:mm:ss") + "'");
        }
        moduleDbQuery.setConditionMap(moduleConditionMap);
        moduleDbQuery.setDb("hainiu_lowcode");
        moduleDbQuery.setSelectOne(Boolean.valueOf(false));
        JSONArray baseModuleList = (JSONArray)this.dbReadUtil.find(moduleDbQuery);
        List list = JSONObject.parseArray((String)baseModuleList.toJSONString(), ManateeGraphDo.class);
        return list;
    }
}

