/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.log;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.log.Formatter;
import com.manatee.lowcode.log.ManateeLoggerContext;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.MDC;

public class Log4j2LoggerContext
implements ManateeLoggerContext {
    @Override
    public void generateAppender() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        LoggerConfig logger = configuration.getRootLogger();
        PatternLayout layout = PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withConfiguration(configuration).withPattern("%d %t %p %X{TracingMsg} %c - %m%n").build();
        ManateeLog4j2Appender appender = new ManateeLog4j2Appender("ManateeLog", logger.getFilter(), (Layout<String>)layout);
        appender.start();
        configuration.addAppender((Appender)appender);
        logger.addAppender((Appender)appender, logger.getLevel(), logger.getFilter());
        context.updateLoggers(configuration);
    }

    static class ManateeLog4j2Appender
    extends AbstractAppender {
        ManateeLog4j2Appender(String name, Filter filter, Layout<String> layout) {
            super(name, filter, layout, true, Property.EMPTY_ARRAY);
        }

        public void append(LogEvent event) {
            String requestId = MDC.get((String)"traceId");
            if (StrUtil.isBlank((CharSequence)requestId) || !requestId.startsWith("D-")) {
                return;
            }
            String loggerName = event.getLoggerName();
            String message = Formatter.create().timestamp(event.getTimeMillis()).value(" --- [").traceId(requestId).value("] ").level(event.getLevel().toString()).value(" --- [").thread(event.getThreadName()).value("] ").loggerName(loggerName).value(": ").value(event.getMessage().getFormattedMessage()).newline().throwable(event.getThrown()).toString();
            boolean isJsProcess = false;
            if (loggerName.endsWith("JsProcess")) {
                isJsProcess = true;
            }
            ManateeLoggerContext.println(message, isJsProcess);
        }
    }
}

