/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.collection;

import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ListMapJoinStringFun
extends AbstractFunction {
    private String name = "listMapJoinString";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        List list = (List)content.getParameter(0);
        String separator = (String)content.getParameter(1);
        String key = (String)content.getParameter(2);
        return ListMapJoinStringFun.getJoinString(list, separator, key);
    }

    public static Object getJoinString(List<Map<String, Object>> list, String separator, String key) {
        ArrayList<String> valueList = new ArrayList<String>();
        for (Map<String, Object> objectMap : list) {
            Object value = objectMap.get(key);
            if (!Objects.nonNull(value)) continue;
            valueList.add(value.toString());
        }
        return StringUtils.join(valueList, (String)separator);
    }

    public Integer getMinParamSize() {
        return 3;
    }

    public Integer getMaxParamSize() {
        return 3;
    }
}

