/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcodedb.manager.DBAopManager;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbQueryAopBo;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.newdb.handler.HandleHelper;
import com.manatee.lowcodedb.newdb.handler.ManateeEntityHandler;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.Order;
import com.manatee.lowcodedb.newdb.tenant.manager.TenantManager;
import com.manatee.lowcodedb.process.CascadeQueryUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManateeQueryOneProcess
implements IProcess {
    private Logger LOGGER = LoggerFactory.getLogger(ManateeQueryOneProcess.class);
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private CascadeQueryUtil cascadeQueryUtil;
    @Resource
    private TenantManager tenantManager;
    @Resource
    private DBAopManager dbAopManager;

    public void process(ProcessContent content) throws BizException {
        String db = this.variableUtil.calVarInConf(content, "db");
        DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get(db);
        String dataBaseName = this.variableUtil.calVarInConf(content, "schema");
        if (StringUtil.isBlank((String)dataBaseName)) {
            dataBaseName = dataSource.getDataBaseName();
        }
        DBQuery query = new DBQuery();
        query.setDb(dataBaseName);
        DbEntity dbEntity = this.createDbEntity(content, dataBaseName, query);
        Object camelCaseData = content.getStepConf().get((Object)"camelCase");
        this.dBManager.camelCase(camelCaseData, query);
        String upperOrLowerCaseData = content.getStepConf().getString("upperOrLowerCase");
        query.setUpperOrLowerCase(upperOrLowerCaseData);
        this.dBManager.sort(content, query);
        Collection<Order> orders = dbEntity.setSortConditionForDbQuery(query.getTable(), query.getSort());
        DbClient use = DbClient.use(db);
        ThreadLocalConnection.INSTANCE.setProcessContent(content);
        try {
            DbEntity dbEntities = use.find(dbEntity, ManateeEntityHandler.create(query.getCamelCase(), upperOrLowerCaseData), (Order[])ArrayUtil.toArray(orders, Order.class), dbEntity.getJoins());
            if (dbEntities != null && dbEntities.size() > 0 && dbEntity.getJoins() != null && dbEntity.getJoins().size() > 0) {
                for (Join join : dbEntity.getJoins()) {
                    if (!"returnObj".equals(join.getJoinReturnDataType()) || join.getJoinQueryFields() == null || join.getJoinQueryFields().size() <= 0) continue;
                    HandleHelper.joinQueryFieldToObject(join, query, dbEntities);
                }
            }
            this.cascadeQueryUtil.cascadeQuery((Object)dbEntities, use, query, content);
            DbQueryAopBo dbQueryAopBo = new DbQueryAopBo();
            dbQueryAopBo.setTableName(query.getTable());
            dbQueryAopBo.setBatch(false);
            dbQueryAopBo.setResultData((Object)dbEntities);
            this.dbAopManager.queryAfterFun(content, dbQueryAopBo);
            Object returnDataShow = content.getStepConf().get((Object)"returnDataShow");
            if (returnDataShow == null || Boolean.valueOf(returnDataShow.toString()).booleanValue()) {
                this.outputUtil.setDefaultReturnKey(content, "outputData");
            }
            String syntaxType = content.getStepConf().getString("syntaxTypeDataProcess");
            this.outputUtil.handleAndPutDataV2(content, (Object)dbEntities, syntaxType);
        }
        catch (SQLException e) {
            this.LOGGER.error("ManateeCountProcess error , db:\u3010{}\u3011", (Object)db);
            throw new BizException((Throwable)e);
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
    }

    private DbEntity createDbEntity(ProcessContent content, String dataBaseName, DBQuery query) throws BizException {
        String table = this.variableUtil.calVarInConf(content, "table");
        query.setTable(table);
        String columns = this.variableUtil.calVarInConf(content, "columns");
        String syntaxType = content.getStepConf().getString("syntaxType");
        List<Map> queryListParams = this.dBManager.getQueryListParamsV2(content, syntaxType);
        DbQueryAopBo dbQueryAopBo = new DbQueryAopBo();
        dbQueryAopBo.setTableName(table);
        dbQueryAopBo.setBatch(false);
        dbQueryAopBo.setColumns(columns);
        dbQueryAopBo.setWhereParams(queryListParams);
        this.dbAopManager.queryBeforeFun(content, dbQueryAopBo);
        columns = dbQueryAopBo.getColumns();
        this.dBManager.join(content, query);
        this.dBManager.cascade(content, query);
        DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setQueryColumnsForDbQuery(table, columns).setWhereConditionListForDbQuery(table, queryListParams, content).setInConditionForDbQuery(table, query.getIn()).setGetOne(true);
        Collection<Join> joins = dbEntity.setJoinConditionForDbQuery(query.getJoin(), content, dataBaseName, this.variableUtil);
        dbEntity.setJoins(joins);
        this.tenantManager.addTenantToEntity(content, dbEntity);
        return dbEntity;
    }

    public String getName() {
        return "manateeQueryOneProcess";
    }
}

