/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.lang.func.VoidFunc1;
import com.manatee.lowcodedb.newdb.AbstractDb;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.dialect.Dialect;
import com.manatee.lowcodedb.newdb.dialect.DialectFactory;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.sql.Wrapper;
import com.manatee.lowcodedb.newdb.transaction.TransactionLevel;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbClient
extends AbstractDb {
    private static final long serialVersionUID = -3378415769645309514L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbClient.class);

    public static DbClient use() throws BizException {
        return DbClient.use(DSFactory.get());
    }

    public static DbClient use(String group) throws BizException {
        return DbClient.use(DSFactory.get(group));
    }

    public static DbClient use(DataSource ds) {
        return ds == null ? null : new DbClient(ds);
    }

    public static DbClient use(DataSource ds, Dialect dialect) {
        return new DbClient(ds, dialect);
    }

    public static DbClient use(DataSource ds, String driverClassName) {
        return new DbClient(ds, DialectFactory.newDialect(driverClassName));
    }

    public DbClient(DataSource ds) {
        this(ds, DialectFactory.getDialect(ds));
    }

    public DbClient(DataSource ds, String driverClassName) {
        this(ds, DialectFactory.newDialect(driverClassName));
    }

    public DbClient(DataSource ds, Dialect dialect) {
        super(ds, dialect);
    }

    @Override
    public DbClient setWrapper(Character wrapperChar) {
        return (DbClient)super.setWrapper(wrapperChar);
    }

    @Override
    public DbClient setWrapper(Wrapper wrapper) {
        return (DbClient)super.setWrapper(wrapper);
    }

    @Override
    public DbClient disableWrapper() {
        return (DbClient)super.disableWrapper();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ThreadLocalConnection.INSTANCE.get(this.ds);
    }

    @Override
    public void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ThreadLocalConnection.INSTANCE.close(this.ds);
    }

    public DbClient tx(VoidFunc1<DbClient> func) throws SQLException {
        return this.tx(null, func);
    }

    public DbClient tx(TransactionLevel transactionLevel, VoidFunc1<DbClient> func) throws SQLException {
        boolean autoCommit;
        Connection conn = this.getConnection();
        this.checkTransactionSupported(conn);
        if (null != transactionLevel) {
            int level = transactionLevel.getLevel();
            if (conn.getTransactionIsolation() < level) {
                conn.setTransactionIsolation(level);
            }
        }
        if (autoCommit = conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        try {
            func.call((Object)this);
            conn.commit();
        }
        catch (Throwable e) {
            this.quietRollback(conn);
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
        finally {
            this.quietSetAutoCommit(conn, autoCommit);
            this.closeConnection(conn);
        }
        return this;
    }

    private void quietRollback(Connection conn) {
        if (null != conn) {
            try {
                conn.rollback();
            }
            catch (Exception e) {
                LOGGER.error("quietRollback", (Throwable)e);
            }
        }
    }

    private void quietSetAutoCommit(Connection conn, Boolean autoCommit) {
        if (null != conn && null != autoCommit) {
            try {
                conn.setAutoCommit(autoCommit);
            }
            catch (Exception e) {
                LOGGER.error("quietRollback", (Throwable)e);
            }
        }
    }
}

