/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.alibaba.fastjson.JSON;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.lang.func.Func1;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.GlobalDbConfig;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.PageResult;
import com.manatee.lowcodedb.newdb.SqlConnRunner;
import com.manatee.lowcodedb.newdb.dialect.Dialect;
import com.manatee.lowcodedb.newdb.handler.BeanListHandler;
import com.manatee.lowcodedb.newdb.handler.HandleHelper;
import com.manatee.lowcodedb.newdb.handler.ManateeEntityHandler;
import com.manatee.lowcodedb.newdb.handler.ManateeListHandler;
import com.manatee.lowcodedb.newdb.handler.NumberHandler;
import com.manatee.lowcodedb.newdb.handler.RsHandler;
import com.manatee.lowcodedb.newdb.handler.StringHandler;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import com.manatee.lowcodedb.newdb.sql.Condition;
import com.manatee.lowcodedb.newdb.sql.DBQuery;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.Order;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.SqlExecutor;
import com.manatee.lowcodedb.newdb.sql.SqlUtil;
import com.manatee.lowcodedb.newdb.sql.Wrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractDb
implements Serializable {
    private static final long serialVersionUID = 3858951941916349062L;
    protected final DataSource ds;
    protected Boolean isSupportTransaction = null;
    protected boolean caseInsensitive = GlobalDbConfig.caseInsensitive;
    protected SqlConnRunner runner;
    protected String dialectName;

    public AbstractDb(DataSource ds, Dialect dialect) {
        this.ds = ds;
        this.runner = new SqlConnRunner(dialect);
        this.dialectName = dialect.dialectName();
    }

    public abstract Connection getConnection() throws SQLException;

    public abstract void closeConnection(Connection var1);

    public List<DbEntity> query(String sql, Map<String, Object> params) throws SQLException {
        return this.query(sql, new ManateeListHandler(this.caseInsensitive), params);
    }

    public List<DbEntity> query(String sql, Object ... params) throws SQLException {
        return this.query(sql, new ManateeListHandler(this.caseInsensitive), params);
    }

    public <T> List<T> query(String sql, Class<T> beanClass, Object ... params) throws SQLException {
        return (List)this.query(sql, new BeanListHandler<T>(beanClass), params);
    }

    public DbEntity queryOne(String sql, Object ... params) throws SQLException {
        return this.query(sql, new ManateeEntityHandler(this.caseInsensitive), params);
    }

    public Number queryNumber(String sql, Object ... params) throws SQLException {
        return this.query(sql, new NumberHandler(), params);
    }

    public String queryString(String sql, Object ... params) throws SQLException {
        return this.query(sql, new StringHandler(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = SqlExecutor.query(conn, sql, rsh, params);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(String sql, RsHandler<T> rsh, Map<String, Object> paramMap) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = SqlExecutor.query(conn, sql, rsh, paramMap);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(Func1<Connection, PreparedStatement> statementFunc, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = SqlExecutor.query(conn, statementFunc, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = SqlExecutor.execute(conn, sql, params);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long executeForGeneratedKey(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            Long l = SqlExecutor.executeForGeneratedKey(conn, sql, params);
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int[] executeBatch(String sql, Object[] ... paramsBatch) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sql, paramsBatch);
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sql, paramsBatch);
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(String ... sqls) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sqls);
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(Iterable<String> sqls) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sqls);
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JSON executeCall(String sql, RsHandler<T> rsh, Map<Integer, Map<String, Object>> outParams, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            JSON jSON = SqlExecutor.executeCall(conn, sql, rsh, outParams, params);
            return jSON;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(DbEntity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.insert(conn, record);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertOrUpdate(DbEntity record, String ... keys) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.insertOrUpdate(conn, record, keys);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int upsert(DbEntity record, String ... keys) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.upsert(conn, record, keys);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] insert(Collection<DbEntity> records) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = this.runner.insert(conn, records);
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> insertForGeneratedKeys(DbEntity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List<Object> list = this.runner.insertForGeneratedKeys(conn, record);
            return list;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object insertForGeneratedKey(DbEntity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            Object object = this.runner.insertForGeneratedKey(conn, record);
            return object;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int del(String tableName, String field, Object value) throws SQLException, BizException {
        return this.del(DbEntity.create(tableName).set(field, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int del(DbEntity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.del(conn, where);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(DbEntity record, DbEntity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.update(conn, record, where);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBatch(Collection<Map> recordAndWhereList) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.updateBatch(conn, recordAndWhereList);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> DbEntity get(String tableName, String field, T value) throws SQLException, BizException {
        return this.get(DbEntity.create(tableName).set(field, value));
    }

    public DbEntity get(DbEntity where) throws SQLException {
        return this.find(where.getFieldNames(), where, new ManateeEntityHandler(this.caseInsensitive), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Collection<String> fields, DbEntity where, RsHandler<T> rsh, Order[] orders, Collection<Join> joins) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.find(conn, fields, where, rsh, orders, joins);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public List<DbEntity> find(Collection<String> fields, DbEntity where) throws SQLException {
        return this.find(fields, where, new ManateeListHandler(this.caseInsensitive), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(DBQuery query, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.find(conn, query, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T find(DbEntity where, RsHandler<T> rsh, String ... fields) throws SQLException {
        return this.find(CollUtil.newArrayList((Object[])fields), where, rsh, null, null);
    }

    public <T> T find(DbEntity where, RsHandler<T> rsh, Order[] orders, Collection<Join> joins) throws SQLException {
        return this.find(where.getFieldNames(), where, rsh, orders, joins);
    }

    public List<DbEntity> find(DbEntity where) throws SQLException {
        return this.find(where.getFieldNames(), where, new ManateeListHandler(this.caseInsensitive), null, null);
    }

    public <T> List<T> find(DbEntity where, Class<T> beanClass) throws SQLException {
        return (List)this.find(where.getFieldNames(), where, BeanListHandler.create(beanClass), null, null);
    }

    public List<DbEntity> findAll(DbEntity where) throws SQLException {
        return this.find(where, ManateeListHandler.create(), new String[0]);
    }

    public <T> List<T> findAll(DbEntity where, Class<T> beanClass) throws SQLException {
        return (List)this.find(where, BeanListHandler.create(beanClass), new String[0]);
    }

    public List<DbEntity> findAll(String tableName) throws SQLException, BizException {
        return this.findAll(DbEntity.create(tableName));
    }

    public List<DbEntity> findBy(String tableName, String field, Object value) throws SQLException, BizException {
        return this.findAll(DbEntity.create(tableName).set(field, value));
    }

    public List<DbEntity> findBy(String tableName, Condition ... wheres) throws SQLException {
        DBQuery query = new DBQuery(wheres, tableName);
        return this.find(query, new ManateeListHandler(this.caseInsensitive));
    }

    public List<DbEntity> findLike(String tableName, String field, String value, Condition.LikeType likeType) throws SQLException, BizException {
        return this.findAll(DbEntity.create(tableName).set(field, SqlUtil.buildLikeValue(value, likeType, true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(DbEntity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long l = this.runner.count(conn, where);
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(SqlBuilder sql) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long l = this.runner.count(conn, sql);
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(CharSequence selectSql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long l = this.runner.count(conn, selectSql, params);
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T page(Collection<String> fields, DbEntity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, fields, where, page, numPerPage, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T page(DbEntity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        return this.page(where, new Page(page, numPerPage), rsh);
    }

    public List<DbEntity> pageForEntityList(DbEntity where, int page, int numPerPage) throws SQLException {
        return this.pageForEntityList(where, new Page(page, numPerPage));
    }

    public List<DbEntity> pageForEntityList(DbEntity where, Page page) throws SQLException {
        return this.page(where, page, new ManateeListHandler(this.caseInsensitive));
    }

    public <T> T page(DbEntity where, Page page, RsHandler<T> rsh) throws SQLException {
        return this.page(where.getFieldNames(), where, page, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T page(Collection<String> fields, DbEntity where, Page page, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, fields, where, page, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T page(CharSequence sql, Page page, RsHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, SqlBuilder.of(sql).addParams(params), page, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> PageResult<T> page(CharSequence sql, Page page, Class<T> elementBeanType, Object ... params) throws SQLException {
        PageResult result = new PageResult(page.getPageNumber(), page.getPageSize(), (int)this.count(sql, params));
        return this.page(sql, page, (ResultSet rs) -> HandleHelper.handleRsToBeanList(rs, result, elementBeanType), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T page(SqlBuilder sql, Page page, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, sql, page, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<DbEntity> page(CharSequence sql, Page page, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PageResult<DbEntity> pageResult = this.runner.page(conn, SqlBuilder.of(sql).addParams(params), page);
            return pageResult;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<DbEntity> page(Collection<String> fields, DbEntity where, int pageNumber, int pageSize) throws SQLException {
        return this.page(fields, where, new Page(pageNumber, pageSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<DbEntity> page(Collection<String> fields, DbEntity where, Page page) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PageResult<DbEntity> pageResult = this.runner.page(conn, fields, where, page);
            return pageResult;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<DbEntity> page(DbEntity where, int page, int numPerPage) throws SQLException {
        return this.page(where, new Page(page, numPerPage));
    }

    public PageResult<DbEntity> page(DbEntity where, Page page) throws SQLException {
        return this.page(where.getFieldNames(), where, page);
    }

    public SqlBuilder pageSql(SqlBuilder find, int pageNum, int pageSize, Boolean camelCase, String upperOrLowerCase) {
        Page page = Page.of(pageNum, pageSize, camelCase, upperOrLowerCase);
        return this.runner.pageSql(find, page);
    }

    public String pageCountSql(String sql) {
        return this.runner.pageCountSql(sql);
    }

    public String getSchema() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            String string = MetaUtil.getSchema(conn);
            return string;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public String getCatalog() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            String string = MetaUtil.getCatalog(conn);
            return string;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public List<String> getSchemas() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List<String> list = this.runner.getSchemas(conn);
            return list;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTablesBySchema(String schema, String tableName) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List<String> list = this.runner.getTablesBySchema(conn, schema, tableName);
            return list;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getColumnNamesBySchemaAndTable(String schema, String tableName) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List<String> list = this.runner.getColumnNamesBySchemaAndTable(conn, schema, tableName);
            return list;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public SqlConnRunner getRunner() {
        return this.runner;
    }

    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }

    public AbstractDb setWrapper(Character wrapperChar) {
        return this.setWrapper(new Wrapper(wrapperChar, this.dialectName));
    }

    public AbstractDb setWrapper(Wrapper wrapper) {
        this.runner.setWrapper(wrapper);
        return this;
    }

    public AbstractDb disableWrapper() {
        return this.setWrapper((Wrapper)null);
    }

    protected void checkTransactionSupported(Connection conn) throws SQLException, DbRuntimeException {
        if (null == this.isSupportTransaction) {
            this.isSupportTransaction = conn.getMetaData().supportsTransactions();
        }
        if (!this.isSupportTransaction.booleanValue()) {
            throw new DbRuntimeException("Transaction not supported for current database!");
        }
    }
}

