/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dameng.init;

import com.manatee.common.exception.BizException;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"manateeDataSourceManager", "ManateeDataSource"})
public class DamengTableFieldsInfo
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DamengTableFieldsInfo.class);
    protected static Map<String, Map<String, List<String>>> damengDatabaseTableFields = new HashMap<String, Map<String, List<String>>>();
    protected static ManateeDataSource manateeDataSource;

    @Resource
    public void setManateeDataSource(ManateeDataSource manateeDataSource) {
        DamengTableFieldsInfo.manateeDataSource = manateeDataSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map allDataSource = manateeDataSource.getAllDataSource();
        Connection connection = null;
        for (Map.Entry dataSource : allDataSource.entrySet()) {
            try {
                connection = ((DataSource)dataSource.getValue()).getConnection();
                String databaseProductName = connection.getMetaData().getDatabaseProductName();
                LOGGER.info("databaseProductName: [{}]", (Object)databaseProductName);
                if (!databaseProductName.equalsIgnoreCase("DM DBMS") && !databaseProductName.equalsIgnoreCase("DAMENG")) continue;
                List<Map<String, String>> allColumns = DamengTableFieldsInfo.getAllColumns(connection, null, null);
                DamengTableFieldsInfo.saveTableFields((String)dataSource.getKey(), allColumns);
            }
            catch (SQLException e) {
                LOGGER.error("DamengTableFieldsInfo.setApplicationContext() error");
                throw new RuntimeException(e);
            }
            finally {
                if (connection == null) continue;
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> refreshTableInfo(Connection con, String dbName, String tableName, String columnName) {
        List<Map<String, String>> tableColumns;
        if (dbName == null || "hainiu_lowcode".equals(dbName) || !damengDatabaseTableFields.containsKey(dbName)) {
            dbName = "default";
        }
        if (con == null) {
            try {
                con = manateeDataSource.getConnection(dbName);
                tableColumns = DamengTableFieldsInfo.getAllColumns(con, tableName, columnName);
            }
            catch (BizException | SQLException e) {
                LOGGER.error("DamengTableFieldsInfo.refreshTableInfo(), Connection get error, dbName: [{}]", (Object)dbName, (Object)e);
                List<String> list = null;
                return list;
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        tableColumns = DamengTableFieldsInfo.getAllColumns(con, tableName, columnName);
        HashMap tableFields = new HashMap();
        for (Map<String, String> map : tableColumns) {
            if (tableFields.containsKey(map.get("tableName"))) {
                ((List)tableFields.get(map.get("tableName"))).add(map.get("columnName"));
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(map.get("columnName"));
            tableFields.put(map.get("tableName"), list);
        }
        if (tableName != null && !tableColumns.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            for (Map<String, String> map : tableColumns) {
                if (!tableName.equals(map.get("tableName"))) continue;
                list.add(map.get("columnName"));
            }
            damengDatabaseTableFields.get(dbName).put(tableName, list);
            return list;
        }
        return null;
    }

    private static void saveTableFields(String dbName, List<Map<String, String>> tableColumns) {
        if (dbName == null || dbName.isEmpty() || tableColumns == null || tableColumns.isEmpty()) {
            LOGGER.error("DamengTableFieldsInfo.saveTableFields() error, dbName: [{}], tableColumns: [{}]", (Object)dbName, tableColumns);
            return;
        }
        HashMap tableFields = new HashMap();
        for (Map<String, String> map : tableColumns) {
            if (tableFields.containsKey(map.get("tableName"))) {
                ((List)tableFields.get(map.get("tableName"))).add(map.get("columnName"));
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(map.get("columnName"));
            tableFields.put(map.get("tableName"), list);
        }
        damengDatabaseTableFields.put(dbName, tableFields);
    }

    private static List<Map<String, String>> getAllColumns(Connection connection, String tableNamePattern, String columnNamePattern) {
        if (connection == null) {
            return null;
        }
        ArrayList<Map<String, String>> columnList = new ArrayList<Map<String, String>>();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schema = MetaUtil.getSchema((Connection)connection);
            ResultSet columns = metaData.getColumns(null, schema, tableNamePattern, columnNamePattern);
            while (columns.next()) {
                HashMap<String, String> columnMap = new HashMap<String, String>();
                String tableName = columns.getString("TABLE_NAME");
                columnMap.put("tableName", tableName);
                String columnName = columns.getString("COLUMN_NAME");
                columnMap.put("columnName", columnName);
                columnList.add(columnMap);
            }
        }
        catch (SQLException e) {
            LOGGER.error("DamengTableFieldsInfo.getAllColumns() error, connection: [{}], tableNamePattern: [{}], columnNamePattern: [{}]", new Object[]{connection, tableNamePattern, columnNamePattern});
        }
        return columnList;
    }

    public List<String> getFieldsByDatabaseName(String dbName, String tableName) {
        if (dbName == null || "hainiu_lowcode".equals(dbName) || !damengDatabaseTableFields.containsKey(dbName)) {
            dbName = "default";
        }
        LOGGER.debug("DamengTableFieldsInfo.getFieldsByDatabaseName(), dbName: [{}], tableName: [{}]", (Object)dbName, (Object)tableName);
        return damengDatabaseTableFields.get(dbName).get(tableName);
    }
}

