/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task.handle;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.dto.TaskDTO;
import com.manatee.camunda.process.service.ManateeTaskService;
import com.manatee.camunda.process.task.handle.TaskHandle;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BackToSpecificNodeTaskHandle
implements TaskHandle {
    @Resource
    private HistoryService historyService;
    @Resource
    private ManateeTaskService manateeTaskService;

    @Override
    @Transactional
    public JSONObject handle(TaskDTO taskDTO) throws BizException {
        Map variables = taskDTO.getVariables();
        String targetTaskId = taskDTO.getTargetTaskId();
        HistoricTaskInstance targetTask = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(targetTaskId).singleResult();
        if (targetTask == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u5386\u53f2\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        int backType = 0;
        if (variables.containsKey("MANATEE_BACK_BACKTYPE") && variables.get("MANATEE_BACK_BACKTYPE") != null) {
            backType = Integer.parseInt(variables.get("MANATEE_BACK_BACKTYPE").toString());
        }
        this.manateeTaskService.rejectToTargetNode_(taskDTO, targetTaskId, backType, 1);
        return null;
    }

    @Override
    public TaskDTO build(TaskDTO taskDTO, ProcessContent content) {
        return taskDTO;
    }
}

