/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.runtime;

import com.manatee.camunda.constant.ProcessStatusEnum;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSON;
import com.manatee.common.util.tool.json.JSONObject;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaGetInstanceProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private HistoryService historyService;

    public void process(ProcessContent content) throws BizException {
        String jsonString;
        ProcessInstance processInstance;
        String processInstanceId = this.variableUtil.calVarInConf(content, "processInstanceId");
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        if (StrUtil.isNotBlank((CharSequence)processInstanceId)) {
            processInstanceQuery.processInstanceId(processInstanceId);
        }
        if ((processInstance = (ProcessInstance)processInstanceQuery.singleResult()) == null) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            ProcessStatusEnum processStatusEnum = ProcessStatusEnum.getProcessStatusEnum(historicProcessInstance.getDeleteReason());
            JSONObject parse = JSONUtil.parseObj((Object)historicProcessInstance);
            parse.set("processStatus", (Object)processStatusEnum.getProcessStatus());
            parse.set("processStatusDesc", (Object)processStatusEnum.getStatusName());
            parse.set("message", (Object)this.filterMsg(historicProcessInstance.getDeleteReason()));
            jsonString = JSONUtil.toJsonStr((JSON)parse);
        } else {
            JSONObject parse = JSONUtil.parseObj((Object)processInstance);
            parse.set("processStatus", (Object)ProcessStatusEnum.RUN.getProcessStatus());
            parse.set("processStatusDesc", (Object)ProcessStatusEnum.RUN.getStatusName());
            jsonString = JSONUtil.toJsonStr((Object)processInstance);
        }
        this.outputUtil.putData(content, com.alibaba.fastjson.JSONObject.parse((String)jsonString));
    }

    private String filterMsg(String msg) {
        return StrUtil.removeAny((CharSequence)msg, (CharSequence[])ProcessStatusEnum.getProcessStatusCodes());
    }

    public String getName() {
        return "camundaGetInstanceProcess";
    }
}

