/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.group;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaGroupProcess
implements IProcess {
    @Autowired
    private IdentityService identityService;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        block25: {
            Group group;
            List<Object> userIds;
            String groupType;
            String groupName;
            String groupId;
            String action;
            block27: {
                block26: {
                    GroupQuery groupQuery;
                    block24: {
                        Object userIdsObject;
                        action = this.variableUtil.calVarInConf(content, "action");
                        String groupIdKey = this.variableUtil.calVarInConf(content, "groupId");
                        groupId = null;
                        if (StringUtil.isNotBlank((String)groupIdKey)) {
                            groupId = content.getValue(groupIdKey).toString();
                        }
                        String groupIdsKey = this.variableUtil.calVarInConf(content, "groupIds");
                        List groupIds = new ArrayList();
                        if (StringUtil.isNotBlank((String)groupIdsKey) && (userIdsObject = content.getValue(groupIdsKey)) instanceof List) {
                            groupIds = (List)userIdsObject;
                        }
                        String groupNameKey = this.variableUtil.calVarInConf(content, "groupName");
                        groupName = null;
                        if (StringUtil.isNotBlank((String)groupNameKey)) {
                            groupName = content.getValue(groupNameKey).toString();
                        }
                        String groupTypeKey = this.variableUtil.calVarInConf(content, "groupType");
                        groupType = null;
                        if (StringUtil.isNotBlank((String)groupTypeKey)) {
                            groupType = content.getValue(groupTypeKey).toString();
                        }
                        String userIdsKey = this.variableUtil.calVarInConf(content, "userIds");
                        userIds = new ArrayList();
                        if (StringUtil.isNotBlank((String)userIdsKey)) {
                            Object userIdsObject2 = content.getValue(userIdsKey);
                            if (userIdsObject2 instanceof List) {
                                userIds = (List)userIdsObject2;
                            } else if (userIdsObject2 instanceof String) {
                                if (userIdsObject2.toString().contains(",")) {
                                    userIds = Arrays.asList(userIdsObject2.toString().split(","));
                                } else {
                                    userIds.add(userIdsObject2.toString());
                                }
                            }
                        }
                        if (!action.equalsIgnoreCase("queryGroups")) break block24;
                        groupQuery = (GroupQuery)this.identityService.createGroupQuery().orderByGroupId().asc();
                        if (!groupIds.isEmpty()) {
                            String[] stringArray = new String[groupIds.size()];
                            groupQuery.groupIdIn(groupIds.toArray(stringArray));
                        }
                        String pageNumStr = this.variableUtil.calVarInConf(content, "pageNum");
                        String string = this.variableUtil.calVarInConf(content, "pageSize");
                        if (StringUtil.isNotBlank((String)pageNumStr) && StringUtil.isNotBlank((String)string)) {
                            Integer pageNum = Integer.valueOf(NumberUtil.isNumber((CharSequence)pageNumStr) ? pageNumStr : content.getValue(pageNumStr).toString());
                            Integer pageSize = Integer.valueOf(NumberUtil.isNumber((CharSequence)string) ? string : content.getValue(string).toString());
                            int firstIndex = (pageNum - 1) * pageSize;
                            groupQuery.listPage(firstIndex, pageSize.intValue());
                        }
                        if (StringUtil.isNotBlank((String)groupId)) {
                            groupQuery.groupId(groupId);
                        }
                        if (StringUtil.isNotBlank((String)groupName)) {
                            groupQuery.groupNameLike(groupName);
                        }
                        List list = groupQuery.list();
                        String totalCountStr = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
                        String totalCount = "totalCount";
                        if (StringUtil.isNotBlank((String)totalCountStr)) {
                            totalCount = content.getValue(totalCountStr).toString();
                        }
                        long count = groupQuery.count();
                        this.outputUtil.putData(content, (Object)list);
                        this.outputUtil.putData(content, totalCount, (Object)count);
                        break block25;
                    }
                    if (!action.equalsIgnoreCase("queryOneGroup")) break block26;
                    groupQuery = this.identityService.createGroupQuery();
                    if (StringUtil.isNotBlank((String)groupId)) {
                        groupQuery.groupId(groupId);
                    }
                    Group group2 = (Group)groupQuery.singleResult();
                    this.outputUtil.putData(content, (Object)group2);
                    break block25;
                }
                if (!action.equalsIgnoreCase("addGroup")) break block27;
                group = this.identityService.newGroup(groupId);
                group.setName(groupName);
                group.setType(groupType);
                this.identityService.saveGroup(group);
                if (userIds.isEmpty()) break block25;
                for (String string : userIds) {
                    this.identityService.createMembership(string, groupId);
                }
                break block25;
            }
            if (action.equalsIgnoreCase("deleteGroup")) {
                group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
                if (group == null) {
                    throw new BizException("\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
                }
                this.identityService.deleteGroup(groupId);
            } else if (action.equalsIgnoreCase("updateGroup")) {
                group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
                if (group == null) {
                    throw new BizException(ResultCode.PARAM_IS_ERROR, "\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
                }
                group.setName(groupName);
                group.setType(groupType);
                this.identityService.saveGroup(group);
                if (!userIds.isEmpty()) {
                    for (String string : userIds) {
                        this.identityService.createMembership(string, groupId);
                    }
                }
            }
        }
    }

    public String getName() {
        return "camundaGroupProcess";
    }
}

