/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.base;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.lowcode.baseModule.init.BaseModuleInit;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.lowcodedb.constant.DataBaseTypeEnum;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Service;

@Service(value="manateeCamundaBaseModule")
public class ManateeCamundaBaseModule
implements BaseModuleInit {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManateeCamundaBaseModule.class);
    private static final String[] BaseModule = new String[]{"saveDeploymentForWangfa", "queryDeploymentListForWangfa", "delDeploymentForWangfa", "getDeploymentForWangfa", "queryProcessInstanceByKeyForWangfa", "instanceOperationsForWangfa", "delProcessInstanceByIdForWangfa", "queryTaskForWangfa", "getProcessInstanceForWangfa", "queryHistoryTasksForWangfa", "camundaQueryGroupListForWangfa", "saveDmnDeploymentForWangfa", "getDmnDeploymentForWangfa", "queryDmnDeploymentForWangfa", "camundaQueryUserListForWangfa", "manateeCamundaTaskEventForWangfa", "bpmnJsonToXmlForWangfa", "getBpmnJsonForWangfa", "camundaTaskHandleForWangfa", "camundaQueryUserListByGroupIdForWangfa", "simpleBpmnQueryGroupForWangfa", "simpleBpmnQueryUserForWangfa"};
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private DataSource dataSource;

    public Map<String, JSONObject> initBaseMoudle() {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        for (String module : BaseModule) {
            JSONObject jsonObject = JSONObject.parseObject((String)BaseModuleUtil.parseFile((String)("baseModuleFiles/" + module + ".json")), (Feature[])new Feature[]{Feature.OrderedField});
            result.put(module, jsonObject);
        }
        this.getStringJSONObjectMap(this.environment);
        return result;
    }

    public void getStringJSONObjectMap(ConfigurableEnvironment environment) {
        String driverClassName = this.dataSourceProperties.getDriverClassName();
        String databaseType = "mysql";
        if (driverClassName.contains(DataBaseTypeEnum.DM.getName())) {
            LOGGER.info("\u8fbe\u68a6\u5f15\u64ce\u521d\u59cb\u5316");
            databaseType = "oracle";
        }
        if (driverClassName.contains(DataBaseTypeEnum.GAUSS.getName())) {
            LOGGER.info("\u9ad8\u65af\u5f15\u64ce\u521d\u59cb\u5316");
            databaseType = "postgres";
        }
        if (driverClassName.contains(DataBaseTypeEnum.YASHANDB.getName())) {
            try (Connection connection = this.dataSource.getConnection();){
                Statement statement = connection.createStatement();
                ResultSet showParameterCompatVector = statement.executeQuery("SHOW PARAMETER COMPAT_VECTOR");
                databaseType = showParameterCompatVector.next() ? "mysql" : "oracle";
            }
            catch (Exception e) {
                LOGGER.error("\u6d41\u7a0b\u5f15\u64ce\u6a21\u5757\u521d\u59cb\u5316\u9519\u8bef", (Throwable)e);
                return;
            }
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("manatee-camunda", Collections.singletonMap("camunda.bpm.database.type", databaseType)));
            LOGGER.info("\u5d16\u5c71\u5f15\u64ce\u521d\u59cb\u5316");
        }
        LOGGER.info("\u6d41\u7a0b\u5f15\u64ce\u6a21\u5757\u521d\u59cb\u5316\u6210\u529f");
    }
}

