/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo.store;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.mongo.MongoClientInit;
import com.manatee.mongo.MongoSqlUtil;
import com.manatee.mongo.domain.BaseMongoSqlInfo;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.mongodb.client.MongoCollection;
import java.util.List;
import javax.annotation.Resource;
import org.bson.Document;
import org.springframework.stereotype.Service;

@Service
public class MongoSqlProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private MongoClientInit mongoClientInit;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        JSONObject conf = content.getStepConf();
        String sql = conf.getString("import").trim();
        String processedSql = this.variableUtil.calVar(content, sql);
        MongoSqlUtil.putExecuteSql(content, processedSql);
        BaseMongoSqlInfo baseMongoSqlInfo = MongoSqlUtil.buildBaseMongoSqlInfo(processedSql);
        MongoCollection<Document> collection = this.mongoClientInit.getCollection(this.mongoClientInit.getSource(), baseMongoSqlInfo.getCollectionName());
        Object result = null;
        switch (baseMongoSqlInfo.getMongoOperationType()) {
            case INSERT_ONE: {
                Document document = MongoSqlUtil.getDocument(baseMongoSqlInfo.getBsonSql());
                collection.insertOne((Object)document);
                result = document.get((Object)"_id");
                break;
            }
            case INSERT_MANY: {
                List<Document> documentList = MongoSqlUtil.getDocumentList(baseMongoSqlInfo.getBsonSql());
                collection.insertMany(documentList);
                result = documentList.size();
                break;
            }
            case FIND_ONE: {
                result = MongoSqlUtil.find(baseMongoSqlInfo.getBsonSql(), collection, true, baseMongoSqlInfo.getMongoOptionList());
                break;
            }
            case FIND: {
                result = MongoSqlUtil.find(baseMongoSqlInfo.getBsonSql(), collection, false, baseMongoSqlInfo.getMongoOptionList());
                break;
            }
            case UPDATE_ONE: {
                result = MongoSqlUtil.updateOne(baseMongoSqlInfo.getBsonSql(), collection);
                break;
            }
            case UPDATE_MANY: {
                result = MongoSqlUtil.updateMany(baseMongoSqlInfo.getBsonSql(), collection);
                break;
            }
            case DELETE_ONE: {
                result = collection.deleteOne(MongoSqlUtil.getBson(baseMongoSqlInfo.getBsonSql())).getDeletedCount();
                break;
            }
            case DELETE_MANY: {
                result = collection.deleteMany(MongoSqlUtil.getBson(baseMongoSqlInfo.getBsonSql())).getDeletedCount();
                break;
            }
            case AGGREGATE: {
                result = MongoSqlUtil.aggregate(baseMongoSqlInfo.getBsonSql(), collection, baseMongoSqlInfo.getMongoOptionList());
                break;
            }
            case COUNT: {
                result = collection.count(MongoSqlUtil.getBson(baseMongoSqlInfo.getBsonSql()));
                break;
            }
            case COUNT_DOCUMENT: {
                result = collection.countDocuments(MongoSqlUtil.getBson(baseMongoSqlInfo.getBsonSql()));
                break;
            }
            case ESTIMATED_DOCUMENT_COUNT: {
                result = collection.estimatedDocumentCount();
                break;
            }
            default: {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u7c7b\u578b");
            }
        }
        this.outputUtil.handleAndPutData(content, result);
    }

    public String getName() {
        return "mongoSql";
    }

    public static void main(String[] args) throws BizException {
        BaseMongoSqlInfo baseMongoSqlInfo = MongoSqlUtil.buildBaseMongoSqlInfo("db.statistic.aggregate([ \n  {$project:{proc:true , out:true, device:true,reportTime:true, raw:true}}\n  ,{ $match: { 'device.nid': { $eq: 'centrifugalChiller/centrifugalChiller_000W00311273Z01PP130302000010000' } } }\n  \n  ,{ $match: { \"out.status\": { $eq: \"success\" } } }\n  ,{ $match: { reportTime: { $gt: ISODate('2023-06-26T15:59:59Z'), $lt: ISODate('2023-07-03T16:00:00Z') } } }\n  ,{ $group: { _id: {\n     dev: \"$device.nid\", report: \"$reportTime\"\n  } , raw:{$first:\"$raw\"},reportTime:{$first:\"$reportTime\"},device:{$first:\"$device\"}}}\n  ,{$sort:{ reportTime: -1 }}\n  ,{$project:{_id:false, reportTime:true\n      , reportTimestampInMilliseconds:{$toLong:\"$reportTime\"} \n      , reportTimeWithZone:{$dateToString:{\n            date:\"$reportTime\",\n            format:\"%G-%m-%dT%H:%M:%S.%L%z\",\n            timezone:\"Asia/Shanghai\"\n        }}\n  , resEnergy_totalEnergy:'$raw.dailyRes.resEnergy_totalEnergy', resfdd_COP:'$raw.dailyRes.resfdd_COP'\n  }}\n],{allowDiskUse: true})");
        MongoSqlUtil.aggregate(baseMongoSqlInfo.getBsonSql(), null, baseMongoSqlInfo.getMongoOptionList());
        System.out.println(baseMongoSqlInfo);
    }
}

