/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.socket.udp;

import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.socket.base.ClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UdpClientProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(UdpClientProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"sendMsg"});
        this.processConfUtil.checkConf(content, new String[]{"socketHost"});
        this.processConfUtil.checkConf(content, new String[]{"socketPort"});
        String sendMsg = this.variableUtil.calVarInConf(content, "sendMsg");
        String socketHost = this.variableUtil.calVarInConf(content, "socketHost");
        String socketPort = this.variableUtil.calVarInConf(content, "socketPort");
        NioEventLoopGroup worker = new NioEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)worker)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ClientHandler(sendMsg, content, this.outputUtil));
            ChannelFuture future = bootstrap.connect(socketHost, Integer.parseInt(socketPort)).sync();
            future.channel().closeFuture().await(1000L);
        }
        catch (Exception e) {
            LOGGER.warn("process error, socketHost:\u3010{}\u3011, socketPort:\u3010{}\u3011, sendMsg:\u3010{}\u3011\uff0ce:{}", new Object[]{socketHost, socketPort, sendMsg, e});
            throw new BizException((Throwable)e);
        }
        finally {
            worker.shutdownGracefully();
        }
    }

    public String getName() {
        return "udpClient";
    }
}

