/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.other;

import com.manatee.common.exception.BizException;
import com.manatee.common.util.StrUtils;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.manager.SpringContextManager;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class GetSpringBeanByNameFun
extends AbstractFunction {
    public String getName() {
        return "getSpringBeanByName";
    }

    public Object doFunction(FunctionContent content) throws BizException {
        this.checkParamSize(content);
        this.checkParamExist(content);
        List parameters = content.getParameters();
        if (parameters == null && parameters.size() != 1) {
            return null;
        }
        Object obj = parameters.get(0);
        if (obj instanceof Class) {
            return SpringContextManager.getBean((Class)((Class)obj));
        }
        String beanName = StrUtils.GetString(obj);
        return SpringContextManager.getBean((String)beanName);
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 1;
    }
}

