/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task.handle;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.dto.TaskDTO;
import com.manatee.camunda.event.ManateeCamundaEvent;
import com.manatee.camunda.process.constants.BpmTaskStatusEnum;
import com.manatee.camunda.process.task.handle.TaskHandle;
import com.manatee.common.util.tool.core.util.IdUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.spring.boot.starter.event.TaskEvent;
import org.springframework.stereotype.Service;

@Service
public class AddSignerTaskHandle
implements TaskHandle {
    @Resource
    private TaskService taskService;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private ManateeCamundaEvent manateeCamundaEvent;

    @Override
    public JSONObject handle(TaskDTO taskDTO) {
        ArrayList<JSONObject> subTaskInfos = new ArrayList<JSONObject>();
        List<String> userIds = taskDTO.getUserIdsAddSigner();
        String addSignerType = taskDTO.getAddSignerType();
        String processorType = taskDTO.getProcessorType();
        String nodeName = taskDTO.getNodeName();
        Task task = taskDTO.getTask();
        String taskId = taskDTO.getTaskId();
        String processInstanceId = taskDTO.getProcessInstanceId();
        String message = taskDTO.getMessage();
        JSONObject result = new JSONObject();
        if (userIds.size() > 0) {
            String nodeHashKey = this.hashDefKeyName();
            String taskDefKey = task.getTaskDefinitionKey() + "#addSigner:" + nodeHashKey;
            for (String processor : userIds) {
                TaskEntity newTaskEntity = (TaskEntity)this.taskService.newTask(IdUtil.fastSimpleUUID());
                newTaskEntity.setProcessInstanceId(processInstanceId);
                if (StringUtils.equals((CharSequence)processorType, (CharSequence)"user")) {
                    newTaskEntity.setAssignee(processor);
                }
                newTaskEntity.setName(nodeName);
                newTaskEntity.setParentTaskId(taskId);
                newTaskEntity.setDescription("@@addSigner:" + nodeName);
                newTaskEntity.setDueDate(task.getDueDate());
                newTaskEntity.setCaseExecutionId(task.getCaseExecutionId());
                newTaskEntity.setPriority(task.getPriority());
                newTaskEntity.setProcessDefinitionId(task.getProcessDefinitionId());
                newTaskEntity.setTaskDefinitionKey(taskDefKey);
                this.taskService.saveTask((Task)newTaskEntity);
                this.pushTaskEvent(taskDTO, newTaskEntity);
                HashMap<String, String> newTaskVariablesMap = new HashMap<String, String>();
                newTaskVariablesMap.put("ADD_SIGNER_TYPE", addSignerType);
                newTaskVariablesMap.put("PROCESSOR_TYPE", processorType);
                this.taskService.setVariablesLocal(taskId, newTaskVariablesMap);
                JSONObject subTask = new JSONObject();
                subTask.put("taskId", (Object)newTaskEntity.getId());
                subTask.put("status", (Object)BpmTaskStatusEnum.WAIT.getStatus());
                subTask.put("addSignerType", (Object)addSignerType);
                subTask.put("processorType", (Object)processorType);
                subTask.put("nodeName", (Object)nodeName);
                subTask.put("taskDefinitionKey", (Object)newTaskEntity.getTaskDefinitionKey());
                if (StringUtils.equals((CharSequence)processorType, (CharSequence)"user")) {
                    subTask.put("taskAssignee", (Object)processor);
                }
                subTaskInfos.add(subTask);
            }
            JSONObject subTaskInfo = new JSONObject();
            subTaskInfo.put("nodeName", (Object)nodeName);
            subTaskInfo.put("subTaskInfos", subTaskInfos);
            subTaskInfo.put("taskDefKey", (Object)taskDefKey);
            subTaskInfo.put("addSignerType", (Object)addSignerType);
            subTaskInfo.put("processorType", (Object)processorType);
            subTaskInfo.put("userIds", userIds);
            subTaskInfo.put("status", (Object)BpmTaskStatusEnum.WAIT.getStatus());
            HashMap<String, Object> variablesMap = new HashMap<String, Object>();
            variablesMap.put("MANATEE_TASK_ADD_SIGNER_STATUS", BpmTaskStatusEnum.WAIT.getStatus());
            ArrayList<String> searchKeys = new ArrayList<String>(2);
            searchKeys.add("MANATEE_TASK_ADD_SIGNER_NODE_INFO");
            searchKeys.add("MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO");
            Map variables = this.taskService.getVariables(taskId, searchKeys);
            Object taskAddSignerNodeInfo = JSONObject.parseArray((String)((String)variables.get("MANATEE_TASK_ADD_SIGNER_NODE_INFO")));
            if (taskAddSignerNodeInfo == null) {
                taskAddSignerNodeInfo = new ArrayList();
            }
            taskAddSignerNodeInfo.add(subTaskInfo);
            variablesMap.put("MANATEE_TASK_ADD_SIGNER_NODE_INFO", JSONObject.toJSONString((Object)taskAddSignerNodeInfo));
            Object taskAddSignerHisNodeInfo = JSONObject.parseArray((String)((String)variables.get("MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
            if (taskAddSignerHisNodeInfo == null) {
                taskAddSignerHisNodeInfo = new ArrayList();
            }
            taskAddSignerHisNodeInfo.add(subTaskInfo);
            variablesMap.put("MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO", JSONObject.toJSONString((Object)taskAddSignerHisNodeInfo));
            this.taskService.setVariablesLocal(taskId, variablesMap);
            result.put("subTaskInfos", subTaskInfos);
        }
        this.taskService.createComment(task.getId(), processInstanceId, message);
        return result;
    }

    @Override
    public TaskDTO build(TaskDTO taskDTO, ProcessContent content) {
        List<String> userIds = new ArrayList<String>();
        String userIdsKey = this.variableUtil.calVarInConf(content, "processor");
        if (StringUtil.isNotBlank((String)userIdsKey)) {
            Object userIdsObject = content.getValue(userIdsKey);
            if (userIdsObject instanceof List) {
                userIds = (List)userIdsObject;
            } else if (userIdsObject instanceof String) {
                if (userIdsObject.toString().contains(",")) {
                    userIds = Arrays.asList(userIdsObject.toString().split(","));
                } else {
                    userIds.add(userIdsObject.toString());
                }
            }
        }
        taskDTO.setUserIdsAddSigner(userIds);
        return taskDTO;
    }

    private String hashDefKeyName() {
        String s = IdUtil.fastSimpleUUID();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = messageDigest.digest(s.getBytes());
            String hash = DatatypeConverter.printHexBinary((byte[])hashBytes);
            return hash.substring(0, 10);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return s;
        }
    }

    private void pushTaskEvent(TaskDTO taskDTO, TaskEntity newTaskEntity) {
        TaskEvent taskEvent = new TaskEvent((DelegateTask)newTaskEntity);
        newTaskEntity.setEventName("create");
        this.manateeCamundaEvent.onTaskEvent(taskEvent);
        newTaskEntity.setEventName("assignment");
        this.manateeCamundaEvent.onTaskEvent(taskEvent);
    }
}

