/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.alibaba.fastjson.JSONObject;
import com.manatee.annotations.ManateeParams;
import com.manatee.annotations.ManateeProcess;
import com.manatee.annotations.ManateeService;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.springframework.stereotype.Service;

@Service
@ManateeService
public class CamundaGetProceessPropertiesProcess {
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private HistoryService historyService;

    @ManateeProcess(name="\u67e5\u8be2\u6d41\u7a0b\u53d8\u91cf\u5c5e\u6027", code="camundaGetProceessPropertiesProcess")
    public JSONObject getProceessProperties(@ManateeParams(value="processInstanceId") String processInstanceId, @ManateeParams(value="pamramName") String pamramName) throws BizException {
        if (StrUtil.isBlank((CharSequence)processInstanceId)) {
            throw new BizException(ResultCode.CONF_ERROR, "\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historicProcessInstanceQuery.processInstanceId(processInstanceId).singleResult();
        String state = historicProcessInstance.getState();
        if (StrUtil.equalsAny((CharSequence)state, (CharSequence[])new CharSequence[]{"COMPLETED", "EXTERNALLY_TERMINATED", "INTERNALLY_TERMINATED"})) {
            HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId);
            if (StrUtil.isNotBlank((CharSequence)pamramName)) {
                HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)historicVariableInstanceQuery.variableName(pamramName).singleResult();
                if (historicVariableInstance == null) {
                    return new JSONObject();
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(pamramName, historicVariableInstance.getValue());
                return jsonObject;
            }
            List list = historicVariableInstanceQuery.list();
            JSONObject jsonObject = new JSONObject();
            for (HistoricVariableInstance historicVariableInstance : list) {
                jsonObject.put(historicVariableInstance.getName(), historicVariableInstance.getValue());
            }
            return jsonObject;
        }
        if (StrUtil.isNotBlank((CharSequence)pamramName)) {
            Object variable = this.runtimeService.getVariable(processInstanceId, pamramName);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(pamramName, variable);
            return jsonObject;
        }
        Map variables = this.runtimeService.getVariables(processInstanceId);
        return new JSONObject(variables);
    }
}

