/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.runtime;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.cache.CacheUtil;
import com.manatee.common.util.tool.cache.impl.LRUCache;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.springframework.stereotype.Service;

@Service
public class CamundaStartFlowProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private IdentityService identityService;
    @Resource
    private RepositoryService repositoryService;
    private static LRUCache<String, JSONObject> EXTENDED_ATTRIBUTES_CACHE = CacheUtil.newLRUCache((int)500, (long)604800000L);

    public void process(ProcessContent content) throws BizException {
        HashMap<String, List<Object>> variables = this.inputUtil.getHandleObject(content, "dataHandle");
        String processDefinitionKey = this.variableUtil.calVarInConf(content, "prcesssKey");
        String businessKey = this.variableUtil.calVarInConf(content, "businessKey");
        String userId = this.variableUtil.calVarInConf(content, "userId");
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            this.identityService.setAuthenticatedUserId(userId);
        }
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        processDefinitionQuery.processDefinitionKey(processDefinitionKey).latestVersion();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.singleResult();
        JSONObject globalResult = this.getExtendedAttributes(processDefinition);
        if (globalResult.containsKey((Object)"manatee_countersign_extended_attribute")) {
            if (variables == null) {
                variables = new HashMap<String, List<Object>>();
            }
            JSONArray countersignExtendedAttribute = JSONArray.parseArray((String)globalResult.getString("manatee_countersign_extended_attribute"));
            for (Object countersignInfo : countersignExtendedAttribute) {
                JSONObject countersignJson = (JSONObject)countersignInfo;
                String processVariableType = countersignJson.getString("processVariableType");
                String processVariableValue = countersignJson.getString("processVariableValue");
                List<Object> valueIds = new ArrayList<String>();
                if (processVariableValue.contains(",")) {
                    valueIds = Arrays.asList(processVariableValue.split(","));
                } else {
                    valueIds.add(processVariableValue);
                }
                if (StringUtils.equals((CharSequence)processVariableType, (CharSequence)"role")) {
                    ArrayList<String> userIdList = new ArrayList<String>();
                    UserQuery usersQuery = (UserQuery)this.identityService.createUserQuery().orderByUserId().asc();
                    for (Object groupId : valueIds) {
                        usersQuery.memberOfGroup(groupId.toString());
                        List userList = usersQuery.list();
                        for (User user : userList) {
                            userIdList.add(user.getId());
                        }
                    }
                    variables.put(countersignJson.getString("processVariableKey"), userIdList);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)processVariableType, (CharSequence)"candidateUsers")) continue;
                variables.put(countersignJson.getString("processVariableKey"), valueIds);
            }
        }
        ProcessInstance processInstance = StrUtil.isNotBlank((CharSequence)businessKey) ? this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, variables) : this.runtimeService.startProcessInstanceByKey(processDefinitionKey, variables);
        this.outputUtil.setDefaultReturnKey(content, "processInstanceId");
        this.outputUtil.putData(content, (Object)processInstance.getId());
    }

    private JSONObject getExtendedAttributes(ProcessDefinition processDefinition) {
        JSONObject cachegGlobalResult = (JSONObject)EXTENDED_ATTRIBUTES_CACHE.get((Object)processDefinition.getId());
        if (cachegGlobalResult != null) {
            return cachegGlobalResult;
        }
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinition.getId());
        JSONObject globalResult = new JSONObject();
        Collection processCollection = bpmnModelInstance.getModelElementsByType(Process.class);
        if (processCollection != null) {
            for (Process process : processCollection) {
                Collection properties;
                ExtensionElements extensionElements = process.getExtensionElements();
                if (extensionElements == null || !CollUtil.isNotEmpty((Collection)extensionElements.getElements()) || !CollUtil.isNotEmpty((Collection)(properties = ((CamundaProperties)extensionElements.getElementsQuery().filterByType(CamundaProperties.class).singleResult()).getCamundaProperties()))) continue;
                for (CamundaProperty property : properties) {
                    String name = property.getCamundaName();
                    String value = property.getCamundaValue();
                    globalResult.put(name, (Object)value);
                }
            }
        }
        EXTENDED_ATTRIBUTES_CACHE.put((Object)processDefinition.getId(), (Object)globalResult);
        return globalResult;
    }

    public String getName() {
        return "camundaStartFlow";
    }
}

