/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import cn.afterturn.easypoi.word.WordExportUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class WordWriteTemplateProcess
implements IProcess {
    private static final Logger log = LoggerFactory.getLogger(WordWriteTemplateProcess.class);
    @Resource
    protected InputUtil inputUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    String CLASSPATH = "classpath";
    String FILE_NAME = "fileName";
    String WRITE_PARAMS = "writeParams";

    public void process(ProcessContent content) throws BizException {
        String suffixName;
        String filePath = this.variableUtil.calVarInConf(content, "filePath");
        if (StringUtil.isBlank((String)filePath)) {
            String classpath = this.variableUtil.calVarInConf(content, this.CLASSPATH);
            filePath = "classpath:" + classpath;
        }
        if (StringUtil.isBlank((String)filePath)) {
            throw new BizException(ResultCode.CONF_ERROR, "file_path_is_null");
        }
        content.putTempContent("filePath", (Object)filePath);
        String fileName = content.getStepConfString(this.FILE_NAME);
        if (StringUtil.isNotBlank((String)fileName)) {
            fileName = this.variableUtil.calVar(content, fileName);
        }
        if (StringUtil.isBlank((String)(suffixName = this.getFileSuffixUsingSubstring(filePath))) || !StringUtil.equals((CharSequence)suffixName, (CharSequence)"doc") && !StringUtil.equals((CharSequence)suffixName, (CharSequence)"docx")) {
            throw new BizException(ResultCode.CONF_ERROR, "\u6a21\u7248\u8def\u5f84\u4e0d\u5408\u6cd5");
        }
        String syntaxType = content.getStepConf().getString("syntaxTypeInsertParams");
        Map writeParams = this.inputUtil.getHandleObjectV2(content, this.WRITE_PARAMS, syntaxType);
        StringBuilder sb = new StringBuilder(GlobalConf.TEMP_DIRECTORY).append(fileName);
        String file = sb.toString();
        if (!file.endsWith(".docx") && !file.endsWith(".doc")) {
            file = file + "." + suffixName;
        }
        if (fileName.contains("/")) {
            String writeFilePath = file.substring(0, file.lastIndexOf("/"));
            File fileTemp = new File(writeFilePath);
            if (!fileTemp.exists()) {
                fileTemp.mkdirs();
            }
        } else {
            File tempDir = new File(GlobalConf.TEMP_DIRECTORY);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
        }
        this.writeWord(filePath, file, writeParams);
        String url = file;
        content.getStepConf().put("returnKey", (Object)"lowcodeTempFileUrl");
        this.outputUtil.putData(content, (Object)url);
    }

    private String getFileSuffixUsingSubstring(String fileName) {
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    private void writeWord(String templatePath, String fileName, Map<String, Object> data) throws BizException {
        MyXWPFDocument xwpfDocument = null;
        OutputStream outputStream = null;
        InputStream inputStreamTemp = null;
        try {
            if (templatePath.indexOf("classpath:") == 0) {
                ClassPathResource classPathResource = new ClassPathResource(templatePath.replace("classpath:", ""));
                inputStreamTemp = classPathResource.getInputStream();
            } else {
                File fileTempData = new File(templatePath);
                inputStreamTemp = new FileInputStream(fileTempData);
            }
            xwpfDocument = new MyXWPFDocument(inputStreamTemp);
            WordExportUtil.exportWord07((XWPFDocument)xwpfDocument, data);
            outputStream = Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
            xwpfDocument.write(outputStream);
        }
        catch (Exception e) {
            log.error("word\u6a21\u677f\u5199\u5165\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BizException(ResultCode.SYSTEM_ERROR, "write_word_error", (Throwable)e);
        }
        finally {
            try {
                if (xwpfDocument != null) {
                    xwpfDocument.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getName() {
        return "wordWriteTemplate";
    }
}

