/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.source;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ModuleBO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="processDataSource")
public class ProcessDataSourceImpl
extends ProcessDataSource {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessDataSourceImpl.class);
    private static String defaultDatabaseProductName;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private BaseModuleUtil baseModuleUtil;
    @Resource
    private ManateeConfig manateeConfig;

    @Value(value="${default-database-product-name:mysql}")
    private void setDefaultDatabaseProductName(String defaultDatabaseProductName) {
        ProcessDataSourceImpl.defaultDatabaseProductName = defaultDatabaseProductName;
    }

    public ModuleBO getDataSource(String code, Long projectId) throws BizException {
        String requestMode;
        Long projectDataId;
        String systemVersion;
        String params;
        if (StringUtil.isBlank((String)code)) {
            return null;
        }
        String configDataSourceTypeNew = this.manateeConfig.getConfigData().getSourceType();
        String configDataSourceType = this.manateeConfig.getConfigDataSourceType();
        JSONObject baseModule = null;
        if (projectId == 0L && this.baseModuleUtil.getPROCESS_CONF_MAP().containsKey(code)) {
            baseModule = this.baseModuleUtil.getPROCESS_CONF_MAP().get(code);
            baseModule.put("moduleName", (Object)code);
            baseModule.put("moduleCode", (Object)code);
            baseModule.put("projectId", (Object)0);
        } else if (StringUtil.isNotBlank((String)configDataSourceType) && StrUtil.equals((CharSequence)"file", (CharSequence)configDataSourceType) || StrUtil.equals((CharSequence)"file", (CharSequence)configDataSourceTypeNew)) {
            baseModule = BaseModuleUtil.getCUSTOM_PROCESS_CONF_MAP().get(projectId + "-" + code);
            baseModule.put("moduleName", (Object)code);
            baseModule.put("moduleCode", (Object)code);
            baseModule.put("projectId", (Object)projectId);
        } else {
            String table = "lowcode_base_module";
            HashMap<String, Object> whereMap = new HashMap<String, Object>(3);
            whereMap.put("module_code", code);
            whereMap.put("valid", 0);
            if (projectId != null) {
                whereMap.put("project_id", projectId);
            }
            baseModule = this.dbReadUtil.getDbEntity(table, whereMap);
        }
        if (baseModule == null) {
            return null;
        }
        ModuleBO moduleBO = new ModuleBO();
        JSONObject processConf = JSONObject.parseObject((String)baseModule.getString("processConf"), (Feature[])new Feature[]{Feature.OrderedField});
        if (processConf != null) {
            List steps = ProcessDataSourceImpl.formatSteps((JSONObject)processConf);
            moduleBO.setSteps(steps);
        }
        String interrupt = baseModule.getString("interrupt");
        Map interruptMap = null;
        if (StringUtil.isNotBlank((String)interrupt)) {
            interruptMap = this.formatInterrupt(JSONObject.parseObject((String)interrupt));
        }
        moduleBO.setInterrupt(interruptMap);
        Boolean isLogin = baseModule.getBoolean("isLogin");
        if (isLogin != null && isLogin.booleanValue()) {
            moduleBO.setLogin(false);
        } else {
            moduleBO.setLogin(true);
        }
        moduleBO.setId(baseModule.getLong("id"));
        String mock = baseModule.getString("mock");
        if (StringUtil.isNotBlank((String)mock)) {
            JSONObject mockJson = JSONObject.parseObject((String)mock);
            moduleBO.setMock(mockJson);
        }
        if (StringUtil.isNotBlank((String)(params = baseModule.getString("params")))) {
            JSONObject paramsJson = JSONObject.parseObject((String)params);
            moduleBO.setParams(paramsJson);
        }
        if (StringUtil.isNotBlank((String)(systemVersion = baseModule.getString("systemVersion")))) {
            moduleBO.setSystemVersion(systemVersion);
        }
        if ((projectDataId = baseModule.getLong("projectId")) != null) {
            moduleBO.setProjectId(projectDataId);
        }
        if (StringUtil.isNotBlank((String)(requestMode = baseModule.getString("requestMode")))) {
            moduleBO.setRequestMode(requestMode);
        }
        moduleBO.setName(baseModule.getString("moduleName"));
        moduleBO.setCode(baseModule.getString("moduleCode"));
        moduleBO.setModuleType(baseModule.getInteger("moduleType"));
        moduleBO.setPath("project" + baseModule.getString("projectId") + "/" + baseModule.getString("moduleCode"));
        return moduleBO;
    }

    public ModuleBO getModuleByVersion(String code, Long projectId, String moduleVersion) throws BizException {
        String requestMode;
        Long projectDataId;
        String systemVersion;
        String params;
        JSONObject baseModule;
        if (StringUtil.isBlank((String)code)) {
            return null;
        }
        if (projectId == 0L && this.baseModuleUtil.getPROCESS_CONF_MAP().containsKey(code)) {
            baseModule = this.baseModuleUtil.getPROCESS_CONF_MAP().get(code);
        } else {
            String table = "lowcode_base_module_history";
            HashMap<String, Object> whereMap = new HashMap<String, Object>(4);
            whereMap.put("module_code", code);
            whereMap.put("valid", 0);
            whereMap.put("module_version", moduleVersion);
            if (projectId != null) {
                whereMap.put("project_id", projectId);
            }
            baseModule = this.dbReadUtil.getDbEntity(table, whereMap);
        }
        if (baseModule == null) {
            return null;
        }
        ModuleBO moduleBO = new ModuleBO();
        JSONObject processConf = JSONObject.parseObject((String)baseModule.getString("processConf"), (Feature[])new Feature[]{Feature.OrderedField});
        if (processConf != null) {
            List steps = ProcessDataSourceImpl.formatSteps((JSONObject)processConf);
            moduleBO.setSteps(steps);
        }
        String interrupt = baseModule.getString("interrupt");
        Map interruptMap = null;
        if (StringUtil.isNotBlank((String)interrupt)) {
            interruptMap = this.formatInterrupt(JSONObject.parseObject((String)interrupt));
        }
        moduleBO.setInterrupt(interruptMap);
        Boolean isLogin = baseModule.getBoolean("isLogin");
        if (isLogin != null && isLogin.booleanValue()) {
            moduleBO.setLogin(false);
        } else {
            moduleBO.setLogin(true);
        }
        moduleBO.setId(baseModule.getLong("moduleId"));
        String mock = baseModule.getString("mock");
        if (StringUtil.isNotBlank((String)mock)) {
            JSONObject mockJson = JSONObject.parseObject((String)mock);
            moduleBO.setMock(mockJson);
        }
        if (StringUtil.isNotBlank((String)(params = baseModule.getString("params")))) {
            JSONObject paramsJson = JSONObject.parseObject((String)params);
            moduleBO.setParams(paramsJson);
        }
        if (StringUtil.isNotBlank((String)(systemVersion = baseModule.getString("systemVersion")))) {
            moduleBO.setSystemVersion(systemVersion);
        }
        if ((projectDataId = baseModule.getLong("projectId")) != null) {
            moduleBO.setProjectId(projectDataId);
        }
        if (StringUtil.isNotBlank((String)(requestMode = baseModule.getString("requestMode")))) {
            moduleBO.setRequestMode(requestMode);
        }
        moduleBO.setName(baseModule.getString("moduleName"));
        moduleBO.setCode(baseModule.getString("moduleCode"));
        moduleBO.setPath("project" + baseModule.getString("projectId") + "/" + baseModule.getString("moduleCode"));
        return moduleBO;
    }

    public JSONObject getProjectConf(Long projectId) throws BizException {
        String configDataSourceType = this.manateeConfig.getConfigDataSourceType();
        if (StringUtil.isNotBlank((String)configDataSourceType) && StrUtil.equals((CharSequence)"file", (CharSequence)configDataSourceType)) {
            JSONObject jsonObject = BaseModuleUtil.getCUSTOM_PROJECT_CONF_MAP().get(projectId.toString());
            if (jsonObject == null) {
                return new JSONObject();
            }
            return jsonObject.getJSONObject("projectConf");
        }
        JSONObject projectConf = new JSONObject();
        try {
            String table = "lowcode_project_conf";
            HashMap<String, Long> whereMap = new HashMap<String, Long>(1);
            whereMap.put("project_id", projectId);
            return this.dbReadUtil.getDbEntity(table, whereMap);
        }
        catch (Throwable e) {
            LOGGER.error("init projectConf error projectId:\u3010{}\u3011, e:{}", (Object)projectId, (Object)e);
            return projectConf;
        }
    }

    public JSONArray getProjectAllModule(Long projectId) throws BizException {
        String table = "lowcode_base_module";
        HashMap<String, Number> whereMap = new HashMap<String, Number>(2);
        whereMap.put("valid", 0);
        if (projectId != null) {
            whereMap.put("project_id", projectId);
        }
        return this.dbReadUtil.queryDbEntity(table, whereMap);
    }

    public JSONArray getAllProjectConf() throws BizException {
        String table = "lowcode_project_conf";
        HashMap whereMap = new HashMap(1);
        return this.dbReadUtil.queryDbEntity(table, whereMap);
    }

    public String getDefaultDatabaseProductName() {
        return defaultDatabaseProductName;
    }

    public ModuleBO getModuleById(Long moduleId, Long projectId) throws BizException {
        JSONObject baseModule;
        if (moduleId == null) {
            return null;
        }
        String table = "lowcode_base_module";
        HashMap<String, Number> whereMap = new HashMap<String, Number>(3);
        whereMap.put("id", moduleId);
        whereMap.put("valid", 0);
        if (projectId != null) {
            whereMap.put("project_id", projectId);
        }
        if ((baseModule = this.dbReadUtil.getDbEntity(table, whereMap)) == null) {
            return null;
        }
        ModuleBO moduleBO = new ModuleBO();
        moduleBO.setName(baseModule.getString("moduleName"));
        moduleBO.setCode(baseModule.getString("moduleCode"));
        JSONObject processConf = JSONObject.parseObject((String)baseModule.getString("processConf"), (Feature[])new Feature[]{Feature.OrderedField});
        if (processConf != null) {
            List steps = ProcessDataSourceImpl.formatSteps((JSONObject)processConf);
            moduleBO.setSteps(steps);
        }
        return moduleBO;
    }

    public JSONObject getDataModelByLogicCode(Long projectId, String logicCode) throws BizException {
        String table = "lowcode_logic_base";
        HashMap<String, Object> whereMap = new HashMap<String, Object>(3);
        whereMap.put("logic_code", logicCode);
        whereMap.put("valid", 0);
        if (projectId != null) {
            whereMap.put("project_id", projectId);
        }
        return this.dbReadUtil.getDbEntity(table, whereMap);
    }

    public List getLogicAttrByLogicId(Long projectId, Long logicId) throws BizException {
        String table = "lowcode_logic_attribute";
        HashMap<String, Number> whereMap = new HashMap<String, Number>(3);
        whereMap.put("logic_id", logicId);
        whereMap.put("valid", 0);
        if (projectId != null) {
            whereMap.put("project_id", projectId);
        }
        return this.dbReadUtil.queryDbEntity(table, whereMap);
    }

    public JSONObject getLogicBehaviorRelById(Long projectId, Long relId) throws BizException {
        String table = "lowcode_logic_behavior_rel";
        HashMap<String, Number> whereMap = new HashMap<String, Number>(3);
        whereMap.put("id", relId);
        whereMap.put("valid", 0);
        if (projectId != null) {
            whereMap.put("project_id", projectId);
        }
        return this.dbReadUtil.getDbEntity(table, whereMap);
    }

    public JSONObject getLogicBehaviorById(Long projectId, Long behaviorId) throws BizException {
        String table = "lowcode_logic_behavior";
        HashMap<String, Number> whereMap = new HashMap<String, Number>(3);
        whereMap.put("id", behaviorId);
        whereMap.put("valid", 0);
        if (projectId != null) {
            whereMap.put("project_id", projectId);
        }
        return this.dbReadUtil.getDbEntity(table, whereMap);
    }

    public List getBehaviorParamsByBehaviorId(Long behaviorId, Integer paramClass) throws BizException {
        String table = "lowcode_logic_behavior_params";
        HashMap<String, Number> whereMap = new HashMap<String, Number>(3);
        whereMap.put("behavior_id", behaviorId);
        whereMap.put("valid", 0);
        if (paramClass != null) {
            whereMap.put("param_class", paramClass);
        }
        return this.dbReadUtil.queryDbEntity(table, whereMap);
    }

    public Long getModuleIdByImplLogicCode(Long projectId, String implLogicCode) throws BizException {
        String table = "lowcode_logic_base";
        HashMap<String, Object> whereMap = new HashMap<String, Object>(4);
        whereMap.put("logic_code", implLogicCode);
        whereMap.put("logic_type", 3);
        whereMap.put("valid", 0);
        if (projectId != null) {
            whereMap.put("project_id", projectId);
        }
        JSONObject logicBaseJson = this.dbReadUtil.getDbEntity(table, whereMap);
        Long logicId = logicBaseJson.getLong("id");
        table = "lowcode_logic_module_rel";
        whereMap = new HashMap(4);
        whereMap.put("logic_id", logicId);
        whereMap.put("rel_type", 1);
        whereMap.put("valid", 0);
        if (projectId != null) {
            whereMap.put("project_id", projectId);
        }
        JSONObject json = this.dbReadUtil.getDbEntity(table, whereMap);
        Long moduleId = null;
        if (json != null && !json.isEmpty()) {
            moduleId = json.getLong("moduleId");
        }
        return moduleId;
    }
}

