/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo.store;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.lowcode.iutil.IJoinManager;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.mongo.MongoReadUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MongoQueryOneProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private MongoReadUtil mongoReadUtil;
    @Resource
    private IJoinManager joinManager;
    @Resource
    private IDBManager dBManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"table"});
        DBQuery dbQuery = this.dBManager.getDBQuery(content, "mongo");
        JSON data = this.queryData(content, dbQuery);
        this.outputUtil.handleAndPutData(content, (Object)data);
    }

    public JSON queryData(ProcessContent content, DBQuery dbQuery) throws BizException {
        JSONObject data = this.mongoReadUtil.findOne(dbQuery);
        this.joinManager.join(content, dbQuery, (JSON)data);
        return data;
    }

    public String getName() {
        return "mongoQueryOne";
    }
}

