/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dbutil.rewriter;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlShuttle;

public class SqlFuncM2GausstionRewriter
extends SqlShuttle {
    public SqlNode visit(SqlCall call) {
        String functionName;
        switch (functionName = call.getOperator().getName().toUpperCase()) {
            case "IFNULL": {
                return this.rewriteIfNull(call);
            }
            case "INET6_ATON": {
                return this.rewriteInet6Aton(call);
            }
        }
        return super.visit(call);
    }

    private SqlNode rewriteInet6Aton(SqlCall call) {
        List operands = call.getOperandList();
        if (operands.size() != 1) {
            return call;
        }
        SqlBasicCall sqlBasicCall = new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier("INET6_ATON", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.STRING), operands.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        SqlBasicCall result = new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier("HEX", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.STRING), Arrays.asList(sqlBasicCall), SqlParserPos.ZERO);
        return result;
    }

    private SqlNode rewriteIfNull(SqlCall call) {
        List operands = call.getOperandList();
        if (operands.size() != 2) {
            return call;
        }
        return new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier("COALESCE", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.STRING), operands.toArray(new SqlNode[0]), SqlParserPos.ZERO);
    }

    private SqlNode rewriteConcat(SqlCall call) {
        List operands = call.getOperandList();
        SqlNode result = (SqlNode)operands.get(0);
        for (int i2 = 1; i2 < operands.size(); ++i2) {
            result = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.CONCAT, new SqlNode[]{result, (SqlNode)operands.get(i2)}, SqlParserPos.ZERO);
        }
        return result;
    }

    private SqlNode rewriteDateFormat(SqlCall call) {
        List operands = call.getOperandList();
        if (operands.size() != 2) {
            return call;
        }
        SqlNode dateExpr = (SqlNode)operands.get(0);
        SqlNode mysqlFormat = (SqlNode)operands.get(1);
        if (!(mysqlFormat instanceof SqlLiteral)) {
            return call;
        }
        String mysqlFmt = ((SqlLiteral)mysqlFormat).toValue();
        String oracleFmt = this.convertMysqlDateFormatToOracle(mysqlFmt);
        SqlNode[] newOperands = new SqlNode[]{dateExpr, SqlLiteral.createCharString((String)oracleFmt, (SqlParserPos)SqlParserPos.ZERO)};
        return new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier("TO_CHAR", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.STRING), newOperands, SqlParserPos.ZERO);
    }

    private SqlNode rewriteStrToDate(SqlCall call) {
        List operands = call.getOperandList();
        if (operands.size() != 2) {
            return call;
        }
        SqlNode dateExpr = (SqlNode)operands.get(0);
        SqlNode mysqlFormat = (SqlNode)operands.get(1);
        if (!(mysqlFormat instanceof SqlLiteral)) {
            return call;
        }
        String mysqlFmt = ((SqlLiteral)mysqlFormat).toValue();
        String oracleFmt = this.convertMysqlDateFormatToOracle(mysqlFmt);
        SqlNode[] newOperands = new SqlNode[]{dateExpr, SqlLiteral.createCharString((String)oracleFmt, (SqlParserPos)SqlParserPos.ZERO)};
        if (oracleFmt.trim().length() <= 10) {
            return new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier("TO_DATE", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.STRING), newOperands, SqlParserPos.ZERO);
        }
        return new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier("TO_TIMESTAMP", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.STRING), newOperands, SqlParserPos.ZERO);
    }

    private String convertMysqlDateFormatToOracle(String mysqlFormat) {
        return mysqlFormat.replace("%Y", "YYYY").replace("%y", "YY").replace("%m", "MM").replace("%d", "DD").replace("%H", "HH24").replace("%i", "MI").replace("%s", "SS");
    }
}

