/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.util;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelColumnWidthStyleStrategy
extends AbstractColumnWidthStyleStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExcelColumnWidthStyleStrategy.class);
    private JSONObject columnStyleJson;

    public ExcelColumnWidthStyleStrategy(JSONObject columnStyleJson) {
        this.columnStyleJson = columnStyleJson;
    }

    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        JSONObject columnWrapTextJson;
        if (this.columnStyleJson == null || this.columnStyleJson.size() <= 0) {
            return;
        }
        Sheet sheet = writeSheetHolder.getSheet();
        int cellColumnIndex = cell.getColumnIndex();
        String cellColumnIndexStr = String.valueOf(cellColumnIndex);
        JSONObject columnWidthJson = this.columnStyleJson.getJSONObject("width");
        if (columnWidthJson != null && columnWidthJson.size() > 0 && columnWidthJson.containsKey((Object)cellColumnIndexStr)) {
            try {
                int columnWidth = columnWidthJson.getIntValue(cellColumnIndexStr);
                sheet.setColumnWidth(cellColumnIndex, columnWidth * 256);
            }
            catch (Exception e) {
                log.error("\u81ea\u5b9a\u4e49\u5217\u5bbd\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        if ((columnWrapTextJson = this.columnStyleJson.getJSONObject("font")) != null && columnWrapTextJson.size() > 0) {
            if (columnWrapTextJson.containsKey((Object)cellColumnIndexStr)) {
                try {
                    String fontStyle = columnWrapTextJson.getString(cellColumnIndexStr);
                    String[] styleArray = fontStyle.split(",");
                    List<String> styleList = Arrays.asList(styleArray);
                    WriteCellData<?> writeCellData = cellDataList.get(0);
                    WriteCellStyle writeCellStyle = writeCellData.getWriteCellStyle();
                    if (writeCellStyle == null) {
                        writeCellStyle = new WriteCellStyle();
                    }
                    if (styleList.contains("wrapText")) {
                        writeCellStyle.setWrapped(Boolean.valueOf(true));
                    } else {
                        writeCellStyle.setWrapped(Boolean.valueOf(false));
                    }
                    WriteFont writeFont = writeCellStyle.getWriteFont();
                    if (writeFont == null) {
                        writeFont = new WriteFont();
                    }
                    if (styleList.contains("bold")) {
                        writeFont.setBold(Boolean.valueOf(true));
                    } else {
                        writeFont.setBold(Boolean.valueOf(false));
                    }
                    writeCellStyle.setWriteFont(writeFont);
                    writeCellData.setWriteCellStyle(writeCellStyle);
                }
                catch (Exception e) {
                    log.error("\u81ea\u5b9a\u4e49\u81ea\u52a8\u6362\u884c\u5f02\u5e38\uff1a", (Throwable)e);
                }
            } else {
                WriteCellData<?> writeCellData = cellDataList.get(0);
                WriteCellStyle writeCellStyle = writeCellData.getWriteCellStyle();
                if (writeCellStyle == null) {
                    writeCellStyle = new WriteCellStyle();
                }
                writeCellStyle.setWrapped(Boolean.valueOf(false));
                WriteFont writeFont = writeCellStyle.getWriteFont();
                if (writeFont == null) {
                    writeFont = new WriteFont();
                }
                writeFont.setBold(Boolean.valueOf(false));
                writeCellStyle.setWriteFont(writeFont);
                writeCellData.setWriteCellStyle(writeCellStyle);
            }
        }
    }
}

