/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.manager;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringContextManager
implements ApplicationContextAware {
    private static Logger LOGGER = LoggerFactory.getLogger(SpringContextManager.class);
    public static ApplicationContext applicationContext = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextManager.applicationContext = applicationContext;
    }

    public static <T> T getBean(Class<T> type) {
        SpringContextManager.assertContextInjected();
        return (T)applicationContext.getBean(type);
    }

    public static Object getBean(String name) {
        SpringContextManager.assertContextInjected();
        return applicationContext.getBean(name);
    }

    public static void assertContextInjected() {
        if (applicationContext == null) {
            throw new RuntimeException("applicationContext\u672a\u6ce8\u5165");
        }
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        SpringContextManager.assertContextInjected();
        return applicationContext.getBeansOfType(type);
    }

    public static String[] getBeanNamesForAnnotation(Class<? extends Annotation> type) {
        SpringContextManager.assertContextInjected();
        return applicationContext.getBeanNamesForAnnotation(type);
    }
}

