/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.io.watch;

import com.manatee.common.util.tool.core.io.IORuntimeException;
import com.manatee.common.util.tool.core.io.watch.WatchMonitor;
import com.manatee.common.util.tool.core.io.watch.Watcher;
import com.manatee.common.util.tool.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;

public class WatchUtil {
    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(url, 0, events);
    }

    public static WatchMonitor create(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(URLUtil.toURI(url), maxDepth, events);
    }

    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(uri, 0, events);
    }

    public static WatchMonitor create(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor create(File file, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(file, 0, events);
    }

    public static WatchMonitor create(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor create(String path, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(path, 0, events);
    }

    public static WatchMonitor create(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(path, 0, events);
    }

    public static WatchMonitor create(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor createAll(URL url, Watcher watcher) {
        return WatchUtil.createAll(url, 0, watcher);
    }

    public static WatchMonitor createAll(URL url, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(URLUtil.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createAll(URI uri, Watcher watcher) {
        return WatchUtil.createAll(uri, 0, watcher);
    }

    public static WatchMonitor createAll(URI uri, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createAll(File file, Watcher watcher) {
        return WatchUtil.createAll(file, 0, watcher);
    }

    public static WatchMonitor createAll(File file, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(file.toPath(), 0, watcher);
    }

    public static WatchMonitor createAll(String path, Watcher watcher) {
        return WatchUtil.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(String path, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createAll(Path path, Watcher watcher) {
        return WatchUtil.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.create(path, maxDepth, WatchMonitor.EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchMonitor createModify(URL url, Watcher watcher) {
        return WatchUtil.createModify(url, 0, watcher);
    }

    public static WatchMonitor createModify(URL url, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(URLUtil.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createModify(URI uri, Watcher watcher) {
        return WatchUtil.createModify(uri, 0, watcher);
    }

    public static WatchMonitor createModify(URI uri, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createModify(File file, Watcher watcher) {
        return WatchUtil.createModify(file, 0, watcher);
    }

    public static WatchMonitor createModify(File file, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(file.toPath(), 0, watcher);
    }

    public static WatchMonitor createModify(String path, Watcher watcher) {
        return WatchUtil.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(String path, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createModify(Path path, Watcher watcher) {
        return WatchUtil.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.create(path, maxDepth, WatchMonitor.ENTRY_MODIFY);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchKey register(Watchable watchable, WatchService watcher, WatchEvent.Kind<?> ... events) {
        try {
            return watchable.register(watcher, events);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

