/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.alibaba.fastjson.JSON;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    private static String PATTERN_STR = ".*(script|eval|e\u00adxpression|javascript:|vbscript:|onload|\\|!).*";
    private static Pattern IS_INVALID_CHARACTER_PATTERN = Pattern.compile(PATTERN_STR);

    public static boolean isNotBlank(String value) {
        return !StringUtil.isBlank(value);
    }

    public static boolean isBlank(String value) {
        if (value == null) {
            return true;
        }
        return "".equals(value.trim());
    }

    public static String replaceSpecialStr(String str) {
        str = str.replaceAll("\\p{Punct}", "");
        return str;
    }

    public static boolean isInvalidCharacter(String str) {
        Matcher m = IS_INVALID_CHARACTER_PATTERN.matcher(str);
        return m.find();
    }

    public static Boolean isInteger(String str) {
        boolean result = false;
        if (str != null && !"".equals(str) && str.matches("^[0-9]*$")) {
            result = true;
        }
        return result;
    }

    public static boolean isEnglish(String fstrData) {
        char c = fstrData.charAt(0);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isChinese(String string) {
        char n = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n < '\u4e00' || n >= '\u9fa5') continue;
            return true;
        }
        return false;
    }

    public static boolean isArry(String data) {
        char fistChar = data.trim().charAt(0);
        return fistChar == '[';
    }

    public static Object jsonParse(String data) {
        if (StringUtil.isBlank(data)) {
            return null;
        }
        char fistChar = data.trim().charAt(0);
        if (fistChar == '[' || fistChar == '{') {
            try {
                return JSON.parse((String)data);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return data;
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (StringUtil.isBlank(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && (chars[start + 1] == 'x' || chars[start + 1] == 'X')) {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return false == allowSigns && foundDigit;
    }

    public static String decodeChar(String content) {
        try {
            char[] decodeChar = content.toCharArray();
            for (int i = 0; i < decodeChar.length; ++i) {
                int c = decodeChar[i];
                decodeChar[i] = (char)(c ^= 0xA);
            }
            content = new String(decodeChar);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public static void main(String[] args) {
    }
}

