/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.manager.DBAopManager;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbUpdateAopBo;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.tenant.manager.TenantManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManateeInsertProcessV2
implements IProcess {
    private Logger LOGGER = LoggerFactory.getLogger(ManateeInsertProcessV2.class);
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private TenantManager tenantManager;
    @Resource
    private DBAopManager dbAopManager;

    public void process(ProcessContent content) throws BizException {
        Object pkNum;
        String table;
        String handleType;
        String pkName;
        block25: {
            this.processConfUtil.checkConf(content, new String[]{"table"});
            String db = this.variableUtil.calVarInConf(content, "db");
            pkName = this.variableUtil.calVarInConf(content, "pkName");
            handleType = content.getStepConfString("handleType");
            table = this.variableUtil.calVarInConf(content, "table");
            String insertType = content.getStepConfString("insertType");
            ThreadLocalConnection.INSTANCE.setProcessContent(content);
            try {
                DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get(db);
                String dataBaseName = this.variableUtil.calVarInConf(content, "schema");
                if (StringUtil.isBlank((String)dataBaseName)) {
                    dataBaseName = dataSource.getDataBaseName();
                }
                if ("batch".equals(handleType)) {
                    int insertNum = 0;
                    Collection<DbEntity> records = this.createDbEntityList(content, dataBaseName, table, insertType);
                    String paramsIsNull = content.getStepConfString("paramsIsNull");
                    if ((StrUtil.isBlank((CharSequence)paramsIsNull) || StrUtil.equals((CharSequence)paramsIsNull, (CharSequence)"error")) && CollUtil.isEmpty(records)) {
                        throw new BizException(ResultCode.CONF_ERROR, String.format("\u6279\u91cf\u63d2\u5165\u7684\u53c2\u6570:\u3010%s\u3011\u4e0d\u80fd\u4e3a\u7a7a", content.getStepConf("paramsKey")));
                    }
                    if (StrUtil.equals((CharSequence)paramsIsNull, (CharSequence)"skip") && CollUtil.isEmpty(records)) {
                        return;
                    }
                    Integer insertBatchNumber = null;
                    try {
                        String insertBatchNumberStr = content.getStepConf().getString("insertBatchNumber");
                        if (StringUtils.isNotEmpty((CharSequence)insertBatchNumberStr)) {
                            insertBatchNumberStr = this.variableUtil.calVar(content, insertBatchNumberStr);
                            insertBatchNumber = Integer.parseInt(insertBatchNumberStr);
                        }
                    }
                    catch (Exception e) {
                        throw new BizException(ResultCode.SYSTEM_ERROR, "\u5355\u6b21\u6dfb\u52a0\u6570\u91cf\u9700\u4e3a\u6570\u5b57");
                    }
                    ArrayList<Collection<Object>> recordsList = new ArrayList<Collection<Object>>();
                    if (insertBatchNumber != null && insertBatchNumber > 0) {
                        List records1 = (List)records;
                        int n = (int)Math.ceil((double)records.size() / (double)insertBatchNumber.intValue());
                        for (int i = 0; i < n; ++i) {
                            int fromIndex = i * insertBatchNumber;
                            int toIndex = Math.min(fromIndex + insertBatchNumber, records1.size());
                            recordsList.add(records1.subList(fromIndex, toIndex));
                        }
                    } else {
                        recordsList.add(records);
                    }
                    for (Collection collection : recordsList) {
                        int[] insert;
                        for (int i : insert = DbClient.use(db).insert(collection)) {
                            if (i <= 0) continue;
                            ++insertNum;
                        }
                    }
                    pkNum = insertNum;
                    break block25;
                }
                DbEntity dbEntity = this.createDbEntity(content, dataBaseName, table, insertType);
                dbEntity.setPk(pkName);
                pkNum = DbClient.use(db).insertForGeneratedKey(dbEntity);
                boolean returnPkNum = false;
                if (content.getStepConf().containsKey((Object)"returnPkNum")) {
                    returnPkNum = content.getStepConf().getBoolean("returnPkNum");
                }
                if (returnPkNum && pkName != null && pkNum == null && dbEntity.containsKey(pkName)) {
                    pkNum = dbEntity.get(pkName);
                }
            }
            catch (SQLException e) {
                this.LOGGER.error("ManateeInsertProcess error , db:\u3010{}\u3011, pkName:\u3010{}\u3011", (Object)db, (Object)pkName);
                String errorMsg = e.getMessage();
                if (errorMsg.contains("Unexpected input 'IGNORE'")) {
                    throw new BizException(ResultCode.SYSTEM_ERROR, "database does not support 'ignore'");
                }
                if (errorMsg.contains("Unexpected input 'REPLACE'")) {
                    throw new BizException(ResultCode.SYSTEM_ERROR, "database does not support 'replace'");
                }
                throw new BizException((Throwable)e);
            }
            finally {
                ThreadLocalConnection.INSTANCE.removeProcessContent();
            }
        }
        String returnKey = "count";
        if (pkName != null) {
            returnKey = pkName;
        }
        DbUpdateAopBo dbUpdateAopBo = new DbUpdateAopBo();
        dbUpdateAopBo.setTableName(table);
        dbUpdateAopBo.setResultData(pkNum);
        dbUpdateAopBo.setBatch("batch".equals(handleType));
        this.dbAopManager.insertOrUpdateAfterFun(content, dbUpdateAopBo);
        if ("batch".equals(handleType)) {
            this.outputUtil.setDefaultReturnKey(content, returnKey);
            this.outputUtil.putData(content, pkNum);
        } else {
            this.outputUtil.setDefaultReturnKey(content, returnKey);
            this.outputUtil.putData(content, pkNum != null && pkName != null ? pkNum : Integer.valueOf(1));
        }
    }

    private Collection<DbEntity> createDbEntityList(ProcessContent content, String dataBaseName, String table, String insertType) throws BizException {
        ArrayList handleListObject = (ArrayList)this.inputUtil.getHandleListObject(content, content.getStepConf("insertParamsArray"), "fieldValue", "paramsKey");
        if (CollUtil.isEmpty((Collection)handleListObject)) {
            String syntaxType = content.getStepConf().getString("syntaxTypeInsertParams");
            List insertParamsObject = (List)this.inputUtil.getHandleDataV2(content, "insertParams", syntaxType);
            if (CollUtil.isEmpty((Collection)insertParamsObject)) {
                return null;
            }
            if (handleListObject == null) {
                handleListObject = new ArrayList();
            }
            for (Map map : insertParamsObject) {
                ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>(2);
                for (Map.Entry param : map.entrySet()) {
                    JSONObject paramJson = new JSONObject();
                    paramJson.put("fieldName", param.getKey());
                    paramJson.put("fieldValue", param.getValue());
                    arrayList.add(paramJson);
                }
                handleListObject.add(arrayList);
            }
        }
        String pkName = this.variableUtil.calVarInConf(content, "pkName");
        DbUpdateAopBo dbUpdateAopBo = new DbUpdateAopBo();
        dbUpdateAopBo.setTableName(table);
        dbUpdateAopBo.setUpdateParams(handleListObject);
        dbUpdateAopBo.setBatch(true);
        this.dbAopManager.insertOrUpdateBeforeFun(content, dbUpdateAopBo);
        ArrayList<DbEntity> result = new ArrayList<DbEntity>(handleListObject.size());
        for (List list : handleListObject) {
            DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setInsertTypeEnum(SqlBuilder.InsertTypeEnum.valueOfString(insertType)).setInsertConditionListV2(list).setPk(pkName);
            this.tenantManager.addTenantToEntity(content, dbEntity);
            result.add(dbEntity);
        }
        return result;
    }

    public String getName() {
        return "manateeInsertProcess_v2";
    }

    private DbEntity createDbEntity(ProcessContent content, String dataBaseName, String table, String insertType) throws BizException {
        List<Map> insertListParams = this.dBManager.getInsertListParams(content);
        if (CollUtil.isEmpty(insertListParams)) {
            String syntaxType = content.getStepConf().getString("syntaxTypeInsertParams");
            Map insertParams = this.inputUtil.getHandleObjectV2(content, "insertParams", syntaxType);
            if (CollUtil.isEmpty((Map)insertParams)) {
                return null;
            }
            if (insertListParams == null) {
                insertListParams = new ArrayList<Map>();
            }
            for (Map.Entry param : insertParams.entrySet()) {
                JSONObject paramJson = new JSONObject();
                paramJson.put("fieldName", param.getKey());
                paramJson.put("fieldValue", param.getValue());
                insertListParams.add((Map)paramJson);
            }
        }
        DbUpdateAopBo dbUpdateAopBo = new DbUpdateAopBo();
        dbUpdateAopBo.setTableName(table);
        dbUpdateAopBo.setUpdateParams(insertListParams);
        dbUpdateAopBo.setBatch(false);
        this.dbAopManager.insertOrUpdateBeforeFun(content, dbUpdateAopBo);
        DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setInsertTypeEnum(SqlBuilder.InsertTypeEnum.valueOfString(insertType)).setInsertConditionList(insertListParams);
        this.tenantManager.addTenantToEntity(content, dbEntity);
        return dbEntity;
    }
}

