/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.FileUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.lowcode.util.GlobalConf;
import io.minio.BaseArgs;
import io.minio.BucketExistsArgs;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.http.Method;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MinioManager {
    private static final Logger log = LoggerFactory.getLogger(MinioManager.class);
    @Resource
    private MinioClient minioClient;

    public JSONObject uploadFile(String fileName, InputStream inputStream, String bucketName, String folder, Boolean autoCover, Boolean isChunk, String chunkIndex) throws BizException {
        JSONObject result = new JSONObject();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            boolean exists = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
            if (!exists) {
                this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            }
            byte[] fileBytes = IoUtil.readBytes((InputStream)inputStream);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            fileName = isChunk != null && isChunk != false ? folder + this.getChunkName(fileName, chunkIndex) : folder + FileUtil.getNewFileName((Boolean)autoCover, (String)fileName);
            byteArrayInputStream = new ByteArrayInputStream(fileBytes);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream((InputStream)byteArrayInputStream, (long)byteArrayInputStream.available(), -1L).build());
            if (isChunk == null || !isChunk.booleanValue()) {
                String url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(fileName)).build());
                result.put("url", (Object)url);
            }
            result.put("fileName", (Object)fileName);
            result.put("fileSize", (Object)fileBytes.length);
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return result;
    }

    public JSONObject uploadFileBase(String base, String bucketName, String folder, String suffix, Boolean autoCover, Boolean isChunk, String chunkIndex, String chunkIdentifier) throws BizException {
        JSONObject result = new JSONObject();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            String fileName;
            boolean exists = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
            if (!exists) {
                this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            }
            byte[] imageByte = Base64.getDecoder().decode(base);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            if (isChunk != null && isChunk.booleanValue()) {
                fileName = folder + this.getChunkName(chunkIdentifier, chunkIndex);
            } else {
                fileName = this.buildBase64Name(imageByte, suffix);
                fileName = folder + FileUtil.getNewFileName((Boolean)autoCover, (String)fileName);
            }
            byteArrayInputStream = new ByteArrayInputStream(imageByte);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream((InputStream)byteArrayInputStream, (long)byteArrayInputStream.available(), -1L).build());
            if (isChunk == null || !isChunk.booleanValue()) {
                String url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(fileName)).build());
                result.put("url", (Object)url);
            }
            result.put("fileName", (Object)fileName);
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return result;
    }

    public String downloadFile(String bucketName, String minioFileName, String downloadFileName) throws BizException {
        InputStream inputStream = null;
        try {
            inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(minioFileName)).build());
            File tempDir = new File(GlobalConf.TEMP_DIRECTORY);
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            File file = new File(tempDir + "/" + downloadFileName);
            try {
                FileUtils.copyToFile((InputStream)inputStream, (File)file);
            }
            catch (Exception e) {
                BizException bizException = new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u6d41\u5199\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                throw bizException;
            }
            if (!file.exists()) {
                BizException bizException = new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728");
                throw bizException;
            }
            String string = file.getPath();
            return string;
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public void removeFile(String bucketName, String minioFileName) throws BizException {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(minioFileName)).build());
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
    }

    public String getUrl(String bucketName, String minioFileName) throws BizException {
        String url = "";
        try {
            url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(minioFileName)).build());
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        return url;
    }

    public JSONObject mergeChunk(String bucketName, String folder, String minioFileName, Boolean autoCover, String chunkTotal, String chunkIdentifier) throws BizException {
        JSONObject result = new JSONObject();
        try {
            int totalChunks = Integer.parseInt(chunkTotal);
            ArrayList<BaseArgs> sources = new ArrayList<BaseArgs>();
            String chunkPath = "chunk/temp/";
            for (int i = 0; i < totalChunks; ++i) {
                String string = chunkPath + this.getChunkName(chunkIdentifier, String.valueOf(i));
                sources.add(((ComposeSource.Builder)((ComposeSource.Builder)ComposeSource.builder().bucket(bucketName)).object(string)).build());
            }
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            minioFileName = folder + FileUtil.getNewFileName((Boolean)autoCover, (String)minioFileName);
            this.minioClient.composeObject((ComposeObjectArgs)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)ComposeObjectArgs.builder().bucket(bucketName)).object(minioFileName)).sources(sources).build());
            for (ComposeSource composeSource : sources) {
                this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(composeSource.object())).build());
            }
            String url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(minioFileName)).build());
            result.put("url", (Object)url);
            result.put("fileName", (Object)minioFileName);
        }
        catch (Exception e) {
            BizException bizException = new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
            bizException.setInterrupt(Integer.valueOf(3));
            throw bizException;
        }
        return result;
    }

    private String buildBase64Name(byte[] imageByte, String suffix) {
        try {
            String base64Str = Base64.getEncoder().encodeToString(imageByte);
            String fileName = DigestUtils.md5Hex((String)base64Str);
            StringBuilder sb = new StringBuilder();
            sb.append(fileName);
            sb.append(".");
            sb.append(suffix);
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getChunkName(String fileName, String chunkIndex) {
        int suffixIndex = fileName.lastIndexOf(StrSplit.P);
        suffixIndex = suffixIndex <= 0 ? fileName.length() : suffixIndex;
        String realName = fileName.substring(0, suffixIndex);
        fileName = realName + "_" + chunkIndex + fileName.substring(suffixIndex);
        return fileName;
    }
}

