/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.pdf.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.RectangleReadOnly;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.manatee.pdf.util.TextWaterMark;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PptToPdfUtil {
    private static final Logger log = LoggerFactory.getLogger(PptToPdfUtil.class);

    public static void pptxToPdf(InputStream inStream, OutputStream outStream, String fileWatermark) throws Exception {
        XMLSlideShow slideShow = new XMLSlideShow(inStream);
        Dimension dimension = slideShow.getPageSize();
        Document pdfDocument = new Document((Rectangle)new RectangleReadOnly(595.0f, 842.0f));
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)pdfDocument, (OutputStream)outStream);
        pdfDocument.open();
        pdfDocument.newPage();
        if (StringUtils.isNotEmpty((CharSequence)fileWatermark)) {
            try {
                pdfWriter.setPageEvent((PdfPageEvent)new TextWaterMark(fileWatermark));
            }
            catch (Exception e) {
                log.error("pdf\u6dfb\u52a0\u6c34\u5370\u5931\u8d25", (Throwable)e);
            }
        }
        Font font = new Font("\u5b8b\u4f53", 0, 12);
        List slideList = slideShow.getSlides();
        int row = slideList.size();
        for (int i = 0; i < row; ++i) {
            XSLFSlide slide = (XSLFSlide)slideList.get(i);
            for (XSLFShape shape : slide.getShapes()) {
                if (!(shape instanceof XSLFTextShape)) continue;
                XSLFTextShape textShape = (XSLFTextShape)shape;
                for (XSLFTextParagraph textParagraph : textShape.getTextParagraphs()) {
                    for (XSLFTextRun textRun : textParagraph.getTextRuns()) {
                        textRun.setFontFamily("\u5b8b\u4f53");
                    }
                }
            }
            BufferedImage bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
            Graphics2D graphics2d = bufferedImage.createGraphics();
            graphics2d.setPaint(Color.white);
            graphics2d.setStroke(new BasicStroke(1.0f));
            graphics2d.setFont(font);
            graphics2d.fill(new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height));
            slide.draw(graphics2d);
            graphics2d.dispose();
            com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((Image)bufferedImage, null);
            image.scalePercent(80.0f);
            pdfDocument.add((Element)image);
        }
        pdfDocument.close();
        pdfWriter.close();
        try {
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
        catch (IOException e) {
            log.error("pptx\u8f6cpdf\u5173\u95edio\u6d41\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    public static void pptToPdf(InputStream inStream, OutputStream outStream, String fileWatermark) throws Exception {
        HSLFSlideShow hslfSlideShow = new HSLFSlideShow(inStream);
        Dimension dimension = hslfSlideShow.getPageSize();
        Document pdfDocument = new Document((Rectangle)new RectangleReadOnly(595.0f, 842.0f));
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)pdfDocument, (OutputStream)outStream);
        pdfDocument.open();
        pdfDocument.newPage();
        if (StringUtils.isNotEmpty((CharSequence)fileWatermark)) {
            try {
                pdfWriter.setPageEvent((PdfPageEvent)new TextWaterMark(fileWatermark));
            }
            catch (Exception e) {
                log.error("pdf\u6dfb\u52a0\u6c34\u5370\u5931\u8d25", (Throwable)e);
            }
        }
        Font font = new Font("\u5b8b\u4f53", 0, 12);
        List slideList = hslfSlideShow.getSlides();
        int row = slideList.size();
        for (int i = 0; i < row; ++i) {
            HSLFSlide slide = (HSLFSlide)slideList.get(i);
            for (HSLFShape shape : slide.getShapes()) {
                if (!(shape instanceof HSLFTextShape)) continue;
                HSLFTextShape textShape = (HSLFTextShape)shape;
                for (HSLFTextParagraph textParagraph : textShape.getTextParagraphs()) {
                    for (HSLFTextRun textRun : textParagraph.getTextRuns()) {
                        textRun.setFontFamily("\u5b8b\u4f53");
                        textRun.setFontIndex(1);
                    }
                }
            }
            BufferedImage bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
            Graphics2D graphics2d = bufferedImage.createGraphics();
            graphics2d.setPaint(Color.white);
            graphics2d.setStroke(new BasicStroke(1.0f));
            graphics2d.setFont(font);
            graphics2d.fill(new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height));
            slide.draw(graphics2d);
            graphics2d.dispose();
            com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((Image)bufferedImage, null);
            image.scalePercent(80.0f);
            pdfDocument.add((Element)image);
        }
        pdfDocument.close();
        pdfWriter.close();
        try {
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
        catch (IOException e) {
            log.error("ppt\u8f6cpdf\u5173\u95edio\u6d41\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    public static void main(String[] args) {
    }
}

