/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dataModel.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.StringUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ModelInterfaceProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private ProcessDataSource processDataSource;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    protected InputUtil inputUtil;
    @Resource
    private ProcessChain processChain;
    @Resource
    private IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"behavior"});
        String modelImplCode = this.getOneVarValue(content, "modelImplCode");
        JSONObject conf = content.getStepConf();
        Long projectId = content.getProjectId();
        Long moduleId = this.processDataSource.getModuleIdByImplLogicCode(projectId, modelImplCode);
        List steps = this.processDataSource.getSteps(projectId, moduleId);
        if (steps == null) {
            BizException exception = new BizException(ResultCode.SYSTEM_ERROR, "module_is_null");
            throw exception;
        }
        Map params = this.inputUtil.getHandleObject(content, "rqParams");
        JSONObject paramsNew = JSONObject.parseObject((String)JSONObject.toJSONString((Object)params));
        ProcessContent moduleContent = new ProcessContent();
        moduleContent.setRequest((Map)paramsNew);
        moduleContent.setTransactionCon(content.getTransactionCon());
        moduleContent.setModule(content.getModule());
        paramsNew.put("tempContext", content.getRequest("tempContext"));
        paramsNew.put("cells", content.getRequest("cells"));
        this.processChain.executeSteps(moduleContent, steps);
        Map moduleResponse = moduleContent.getResponse();
        Object returnDataShow = content.getStepConf().get((Object)"returnDataShow");
        if (returnDataShow == null || Boolean.valueOf(returnDataShow.toString()).booleanValue()) {
            this.outputUtil.setDefaultReturnKey(content, "outputData");
        }
        this.outputUtil.handleAndPutData(content, (Object)moduleResponse);
    }

    private String getOneVarValue(ProcessContent content, String varKey) {
        Object varValueObj;
        String varKeyValue = this.variableUtil.calVarInConf(content, varKey);
        String varValue = null;
        if (StringUtil.isNotBlank((String)varKeyValue) && (varValueObj = content.getValue(varKeyValue)) != null) {
            varValue = varValueObj.toString();
        }
        return varValue;
    }

    public String getName() {
        return "modelInterfaceProcess";
    }
}

