CREATE TABLE `lowcode_base_module_history` (
    `module_id` bigint(20) NOT NULL COMMENT '接口id',
    `module_code` varchar(100) NOT NULL DEFAULT '' COMMENT '英文名称',
    `module_name` varchar(100) NOT NULL DEFAULT '' COMMENT 'api名称',
    `module_description` varchar(255) NOT NULL DEFAULT '' COMMENT '接口描述',
    `module_version` varchar(16) NOT NULL DEFAULT 'v1.0.0' COMMENT '版本',
    `env` varchar(16) NOT NULL DEFAULT '' COMMENT '环境',
    `package_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '包id',
    `project_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '项目id\\n0 代表系统',
    `module_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '接口模块 1  , 计算模块 2 , 子模块  0 , 抽象模块 3',
    `request_mode` varchar(16) NOT NULL DEFAULT 'POST' COMMENT '请求方式：GET/POST',
    `is_login` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否需要登录，需要  0  不需要1',
    `process_conf` text COMMENT '流程配置',
    `valid` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态\n-1 删除  \n0 正常',
    `gmt_create` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `gmt_modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    `params` text COMMENT '参数',
    `mock` text COMMENT 'mock返回',
    `chart_url` varchar(255) NOT NULL DEFAULT '' COMMENT '流程图url',
    `interrupt` text COMMENT '中断配置',
    `create_user` bigint(20) NOT NULL DEFAULT '0' COMMENT '创建用户id',
    `modified_user` bigint(20) NOT NULL DEFAULT '0' COMMENT '更新用户id',
    `system_version` varchar(16) NOT NULL DEFAULT '' COMMENT '接口版本',
    `conf` text COMMENT '接口配置',
    `sort` int(11) NOT NULL DEFAULT '1' COMMENT '排序',
    KEY `valid_projectId_code_version` (`valid`,`project_id`,`module_code`,`module_version`) USING BTREE COMMENT '单个接口查询',
    KEY `idx_module_id` (`module_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='积木模块'