CREATE TABLE `lowcode_compiler` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `project_id` bigint(20) NOT NULL,
    `module_id` bigint(20) NOT NULL,
    `bean_name` varchar(64) NOT NULL,
    `compiler_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '编译语言类型：1.Java',
    `compiler_code` text NOT NULL COMMENT '编译前代码',
    `compiler_data` longblob COMMENT '编译后数据',
    `compiler_state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '编译状态：-1.编译失败，0.未编译 ， 1.已编译',
    `compiler_version` int(11) NOT NULL DEFAULT '0' COMMENT '编译版本',
    `ext1` varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext2` varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `ext3` varchar(255) DEFAULT NULL COMMENT '扩展字段',
    `valid` tinyint(4) DEFAULT NULL COMMENT '\\n-1：删除      \\n0 ：正常',
    `create_user` bigint(20) DEFAULT NULL COMMENT '创建人',
    `modified_user` bigint(20) DEFAULT NULL COMMENT '更新人',
    `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
    `gmt_modified` datetime DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uidx_compile_bean_name` (`bean_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8