/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.process.store.handle.ManateeFileHandle;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.ProcessFileInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalFileUploadProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(LocalFileUploadProcess.class);
    @Resource
    private ManateeFileHandle manateeFileHandle;
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private IOutputUtil outputUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"foldPath"});
        String foldPath = this.variableUtil.calVarInConf(content, "foldPath");
        String fileSource = content.getStepConf().getString("fileSource");
        Boolean needDel = content.getStepConf().getBoolean("needDel");
        Boolean needMakeDirectory = content.getStepConf().getBoolean("needMakeDirectory");
        Boolean autoCover = content.getStepConf().getBoolean("autoCover");
        ArrayList fileInfos = new ArrayList();
        this.manateeFileHandle.getContentFiles(content, fileSource, needDel, autoCover, fileInfos);
        String returnType = content.getStepConf().getString("returnType");
        File foldPathFile = new File(foldPath);
        if (!foldPathFile.exists() && !needMakeDirectory.booleanValue()) {
            throw new BizException(ResultCode.CONF_ERROR, "\u3010" + foldPath + "\u3011\uff0c \u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        if (!foldPathFile.exists() && needMakeDirectory.booleanValue()) {
            foldPathFile.mkdirs();
        }
        ArrayList<String> path = new ArrayList<String>(fileInfos.size());
        ArrayList resultList = new ArrayList(fileInfos.size());
        for (ProcessFileInfo fileInfo : fileInfos) {
            String fileName = fileInfo.getFileName();
            String fulllFileName = foldPath + fileName;
            if (!foldPath.endsWith("/") && !fileName.startsWith("/")) {
                fulllFileName = foldPath + "/" + fileName;
            }
            File saveFile = new File(fulllFileName);
            FileOutputStream fo = null;
            InputStream fileInfoInputStream = null;
            try {
                fo = new FileOutputStream(saveFile);
                fileInfoInputStream = fileInfo.getInputStream();
                int fileSize = IOUtils.copy((InputStream)fileInfoInputStream, (OutputStream)fo);
                File file = fileInfo.getFile();
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("fileName", fileName);
                result.put("path", fulllFileName);
                result.put("size", fileSize);
                result.put("suffix", fileName.substring(fileName.lastIndexOf(".") + 1));
                if (fileInfo.getNeedDel() != null && fileInfo.getNeedDel().booleanValue() && file != null && file.exists()) {
                    file.delete();
                }
                path.add(fulllFileName);
                resultList.add(result);
            }
            catch (IOException e) {
                LOGGER.error("localFileUpload error", (Throwable)e);
            }
            finally {
                try {
                    if (fo != null) {
                        ((OutputStream)fo).close();
                    }
                    if (fileInfoInputStream == null) continue;
                    fileInfoInputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("localFileUpload error", (Throwable)e);
                }
            }
        }
        if (StringUtil.isNotBlank((String)returnType) && StringUtils.equals((CharSequence)returnType, (CharSequence)"1")) {
            this.outputUtil.handleAndPutData(content, resultList);
        } else {
            this.outputUtil.handleAndPutData(content, path);
        }
    }

    public String getName() {
        return "localFileUpload";
    }
}

